/*
 * 쐬: 2008/08/05
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFEclipse Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.wizards;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.OracleSequence;
import zigen.plugin.db.ui.internal.OracleSource;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.TreeNode;
import zigen.plugin.db.ui.jobs.ConnectDBJob;
import zigen.plugin.db.ui.jobs.OpenEditorJob;
import zigen.plugin.db.ui.jobs.OpenSourceEditorJob;
import zigen.plugin.db.ui.jobs.OracleSequeceSearchJob;
import zigen.plugin.db.ui.jobs.OracleSourceSearchJob;
import zigen.plugin.db.ui.jobs.RefreshFolderJob;
import zigen.plugin.db.ui.jobs.TableTypeSearchJob;

public class TreeDoubleClickHandler implements IDoubleClickListener {

	private boolean showDialog = false;
	
	private SelectTableDialog dialog;

	public TreeDoubleClickHandler(SelectTableDialog dialog) {
		this.dialog = dialog;
	}

	public void doubleClick(DoubleClickEvent event) {

		try {

			Viewer view = event.getViewer();
			ISelection selection = event.getSelection();
			if (view instanceof TreeViewer && selection instanceof StructuredSelection) {
				TreeViewer viewer = (TreeViewer) view;
				Object element = ((StructuredSelection) selection).getFirstElement();

				if(element instanceof ITable){
					dialog.close();
				}
//				if (element instanceof TreeNode) {
//					// ȊÕm[hvf͓WJ܂͔WJs
//					changeExpandedState(viewer, (TreeNode) element);
//				}
			}
		} catch (Exception e) {
			DbPlugin.log(e);
		}

	}

	/**
	 * WJEWJ̐؂ւ
	 * 
	 * @param element
	 */
	private void changeExpandedState(TreeViewer viewer, TreeNode element) {

		// vfWJԂǂ
		if (!viewer.getExpandedState(element)) {

			viewer.expandToLevel(element, 1); // WJԂɂ

			// ݂́uTABLEvtH_z炩ߌĂ邽߁Aȉ̏OK

			if (element instanceof Schema) {

				Schema schema = (Schema) element;

				if (!schema.isExpanded()) {
					schema.setExpanded(true);
					// e[uꗗi񓯊ɂĎsj
					TableTypeSearchJob job = new TableTypeSearchJob(viewer, schema);
					job.setPriority(TableTypeSearchJob.SHORT);
					job.setUser(showDialog); // _CAOo
					job.schedule();
				}

			} else if (element instanceof Folder) {
				Folder folder = (Folder) element;
				if (!folder.isExpanded()) {
					folder.setExpanded(true);
					Schema schema = folder.getSchema();
					if (schema != null) {
						switch (DBType.getType(schema.getDbConfig())) {
						case DBType.DB_TYPE_ORACLE:
							if (schema != null) {
								if ("VIEW".equals(folder.getName())) { //$NON-NLS-1$
									RefreshFolderJob job = new RefreshFolderJob(viewer, folder);
									job.setPriority(OracleSequeceSearchJob.SHORT);
									job.setUser(showDialog);
									job.schedule();
									return;
								}
							}
						default:
							//  OracleȊOŃtH__uNbNꍇ̏ǉ
							RefreshFolderJob job = new RefreshFolderJob(viewer, folder);
							job.setPriority(OracleSequeceSearchJob.SHORT);
							job.setUser(showDialog);
							job.schedule();
							// 
							break;
						}
					}
				}

			}

		} else {
			viewer.collapseToLevel(element, 1); // WJԂɂ
		}

	}
}
