/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.rule.AbstractMappingFactory;
import zigen.plugin.db.core.rule.IMappingFactory;
import zigen.plugin.db.ui.internal.ITable;

public class DeleteSQLInvoker {
    public static int invoke(IDBConfig config, ITable table, TableColumn[] uniqueColumns, Object[] uniqueItems) throws Exception {
        try {
            Connection con = Transaction.getInstance(config).getConnection();
            return DeleteSQLInvoker.invoke(con, table, uniqueColumns, uniqueItems);
        }
        catch (Exception e) {
            DbPlugin.log(e);
            throw e;
        }
    }

    public static int invoke(Connection con, ITable table, TableColumn[] uniqueColumns, Object[] uniqueItems) throws Exception {
        int n;
        String nullSymbol = DbPlugin.getDefault().getPreferenceStore().getString("PreferencePage.NullSymbol");
        StringBuffer sb = new StringBuffer();
        PreparedStatement pst = null;
        try {
            int rowAffected;
            IMappingFactory factory = AbstractMappingFactory.getFactory(table.getDbConfig());
            sb.append("DELETE FROM ");
            sb.append(String.valueOf(table.getSqlTableName()) + " ");
            int i = 0;
            while (i < uniqueColumns.length) {
                if (i == 0) {
                    sb.append("WHERE ");
                    sb.append(uniqueColumns[i].getColumnName());
                    if (uniqueItems[i] == null || nullSymbol.equals(uniqueItems[i])) {
                        sb.append(" is null ");
                    } else {
                        sb.append(" = ? ");
                    }
                } else {
                    sb.append("AND ");
                    sb.append(uniqueColumns[i].getColumnName());
                    if (uniqueItems[i] == null || nullSymbol.equals(uniqueItems[i])) {
                        sb.append(" is null ");
                    } else {
                        sb.append(" = ? ");
                    }
                }
                ++i;
            }
            pst = con.prepareStatement(sb.toString());
            int index = 0;
            int i2 = 0;
            while (i2 < uniqueItems.length) {
                if (uniqueItems[i2] != null && !nullSymbol.equals(uniqueItems[i2])) {
                    factory.setObject(pst, ++index, uniqueColumns[i2], uniqueItems[i2]);
                }
                ++i2;
            }
            n = rowAffected = pst.executeUpdate();
        }
        catch (Exception e) {
            try {
                DbPlugin.log(e);
                throw e;
            }
            catch (Throwable throwable) {
                StatementUtil.close(pst);
                throw throwable;
            }
        }
        StatementUtil.close(pst);
        return n;
    }
}

