/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import zigen.plugin.db.DbPlugin;

public class DriverSearcherWithProgress
implements IRunnableWithProgress {
    private ClassLoader loader;
    private String[] classpaths;
    private List driverNames;

    public DriverSearcherWithProgress(ClassLoader loader, String[] classpaths) {
        this.loader = loader;
        this.classpaths = classpaths;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("Search for DriverName...", this.calcTotalWork());
        this.driverNames = this.searchDriver(monitor);
        monitor.done();
    }

    private int calcTotalWork() {
        int cnt = 0;
        ZipInputStream in = null;
        try {
            int i = 0;
            while (i < this.classpaths.length) {
                try {
                    if (this.classpaths[i].endsWith(".class")) {
                        ++cnt;
                    } else {
                        File classFile = new File(this.classpaths[i]);
                        in = new ZipInputStream(new FileInputStream(classFile));
                        while (in.getNextEntry() != null) {
                            ++cnt;
                        }
                    }
                }
                catch (FileNotFoundException ex) {
                    DbPlugin.log(ex);
                }
                catch (IOException ex) {
                    DbPlugin.log(ex);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception exception) {}
        return cnt;
    }

    public List searchDriver(IProgressMonitor monitor) throws InterruptedException {
        ArrayList driverList = new ArrayList();
        ZipInputStream in = null;
        try {
            int i = 0;
            while (i < this.classpaths.length) {
                monitor.subTask(this.classpaths[i]);
                try {
                    if (this.classpaths[i].endsWith(".class")) {
                        this.addDriverList(monitor, driverList, this.classpaths[i]);
                    } else {
                        File classFile = new File(this.classpaths[i]);
                        in = new ZipInputStream(new FileInputStream(classFile));
                        ZipEntry entry = null;
                        while ((entry = in.getNextEntry()) != null) {
                            if (monitor.isCanceled()) {
                                throw new InterruptedException("Search of DriverName was canceled. ");
                            }
                            this.addDriverList(monitor, driverList, entry.getName());
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    DbPlugin.log(e);
                }
                catch (IOException e) {
                    DbPlugin.log(e);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception exception) {}
        return driverList;
    }

    private void addDriverList(IProgressMonitor monitor, List driverList, String name) {
        if (name.endsWith(".class")) {
            name = name.replace('/', '.').substring(0, name.length() - 6);
            monitor.subTask(name);
            try {
                Class<?> clazz = this.loader.loadClass(name);
                if (!Driver.class.isAssignableFrom(clazz) || Driver.class.equals(clazz)) {
                    monitor.worked(1);
                    return;
                }
                driverList.add(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                monitor.worked(1);
                return;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                monitor.worked(1);
                return;
            }
            catch (Exception exception) {
                monitor.worked(1);
                return;
            }
        }
        monitor.worked(1);
    }

    public List getDriverNames() {
        return this.driverNames;
    }
}

