/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;

public class InputStreamUtil {
    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        int i;
        byte[] out = null;
        ByteArrayOutputStream sw = null;
        byte[] buf = new byte[1024];
        sw = new ByteArrayOutputStream();
        while ((i = inputStream.read(buf, 0, buf.length)) != -1) {
            sw.write(buf, 0, i);
        }
        sw.flush();
        sw.close();
        out = sw.toByteArray();
        return out;
    }

    public static void save(File file, InputStream inputStream) throws IOException {
        DataInputStream dis = null;
        FileOutputStream fos = null;
        byte[] buf = new byte[1024];
        try {
            int i;
            dis = new DataInputStream(inputStream);
            fos = new FileOutputStream(file);
            while ((i = dis.read(buf, 0, buf.length)) != -1) {
                fos.write(buf, 0, i);
            }
            fos.flush();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (dis != null) {
                dis.close();
            }
        }
    }

    public static String toString(InputStream inputStream, String charsetName) throws IOException {
        String out = null;
        InputStreamReader br = null;
        StringWriter sw = null;
        char[] buf = new char[1024];
        try {
            int i;
            br = new InputStreamReader(inputStream, charsetName);
            sw = new StringWriter();
            while ((i = br.read(buf, 0, buf.length)) != -1) {
                sw.write(buf, 0, i);
            }
            sw.flush();
            sw.close();
            out = sw.toString();
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return out;
    }

    public static void save(File file, Reader reader) throws IOException {
        FileWriter fw = null;
        char[] buf = new char[1024];
        try {
            int i;
            fw = new FileWriter(file);
            while ((i = reader.read(buf, 0, buf.length)) != -1) {
                fw.write(buf, 0, i);
            }
            fw.flush();
        }
        finally {
            if (fw != null) {
                fw.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static String toString(Reader reader) throws IOException {
        String out = null;
        StringWriter sw = null;
        char[] buf = new char[1024];
        try {
            int i;
            sw = new StringWriter();
            while ((i = reader.read(buf, 0, buf.length)) != -1) {
                sw.write(buf, 0, i);
            }
            sw.flush();
            sw.close();
            out = sw.toString();
        }
        finally {
            reader.close();
        }
        return out;
    }

    public static char[] toCharArray(Reader reader) throws IOException {
        int i;
        char[] out = null;
        CharArrayWriter cw = null;
        char[] buf = new char[1024];
        cw = new CharArrayWriter();
        while ((i = reader.read(buf, 0, buf.length)) != -1) {
            cw.write(buf, 0, i);
        }
        cw.flush();
        cw.close();
        out = cw.toCharArray();
        return out;
    }
}

