/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.rule.AbstractMappingFactory;
import zigen.plugin.db.core.rule.IMappingFactory;
import zigen.plugin.db.ui.internal.ITable;

public class InsertSQLInvoker {
    public static int invoke(IDBConfig config, ITable table, TableColumn[] insertColumns, Object[] insertItems) throws Exception {
        Connection con = Transaction.getInstance(config).getConnection();
        return InsertSQLInvoker.invoke(con, table, insertColumns, insertItems);
    }

    public static int invoke(Connection con, ITable table, TableColumn[] insertColumns, Object[] insertItems) throws Exception {
        int n;
        StringBuffer sb = new StringBuffer();
        PreparedStatement pst = null;
        try {
            int rowAffected;
            IMappingFactory factory = AbstractMappingFactory.getFactory(table.getDbConfig());
            sb.append("INSERT INTO ");
            sb.append(String.valueOf(table.getSqlTableName()) + " ");
            sb.append("VALUES (");
            int i = 0;
            while (i < insertItems.length) {
                if (i == 0) {
                    sb.append("?");
                } else {
                    sb.append(", ?");
                }
                ++i;
            }
            sb.append(")");
            pst = con.prepareStatement(sb.toString());
            int index = 0;
            int i2 = 0;
            while (i2 < insertItems.length) {
                factory.setObject(pst, ++index, insertColumns[i2], insertItems[i2]);
                ++i2;
            }
            n = rowAffected = pst.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                StatementUtil.close(pst);
                throw throwable;
            }
        }
        StatementUtil.close(pst);
        return n;
    }
}

