/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IViewPart;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.SQLHistory;
import zigen.plugin.db.core.SQLHistoryManager;
import zigen.plugin.db.ui.views.HistoryView;

public class SQLHistoryAddWithProgress
implements IRunnableWithProgress {
    SQLHistoryManager mgr;
    SQLHistory history;

    public SQLHistoryAddWithProgress(SQLHistory history) {
        this.history = history;
        this.mgr = DbPlugin.getDefault().getHistoryManager();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("Add SQL History...", -1);
        try {
            try {
                IViewPart part;
                if (this.mgr.addHistory(this.history) && (part = DbPlugin.findView("zigen.plugin.db.ui.views.HistoryView")) instanceof HistoryView) {
                    HistoryView hv = (HistoryView)part;
                    hv.updateHistoryView(this.history);
                    DbPlugin.fireStatusChangeListener(hv, 101);
                }
            }
            catch (IOException e) {
                DbPlugin.getDefault().showErrorDialog(e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

