/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.Transaction;

public class SchemaSearcher {
    public static String[] execute(IDBConfig config) throws Exception {
        Connection con = Transaction.getInstance(config).getConnection();
        return SchemaSearcher.execute(con);
    }

    public static String[] execute(Connection con) throws Exception {
        String[] stringArray;
        ArrayList<String> list = new ArrayList<String>();
        ResultSet rs = null;
        Statement st = null;
        try {
            DatabaseMetaData objMet = con.getMetaData();
            if (!SchemaSearcher.isSupport(con)) {
                String[] stringArray2 = new String[]{};
                return stringArray2;
            }
            list = new ArrayList();
            if (DBType.getType(objMet) == 2 && objMet.getDatabaseMajorVersion() >= 5) {
                String s = "SELECT SCHEMA_NAME AS TABLE_SCHEM FROM information_schema.SCHEMATA";
                st = con.createStatement();
                rs = st.executeQuery(s);
            } else {
                rs = objMet.getSchemas();
            }
            while (rs.next()) {
                String wk = rs.getString("TABLE_SCHEM");
                list.add(wk);
            }
            stringArray = list.toArray(new String[0]);
            StatementUtil.close(st);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            StatementUtil.close(st);
            ResultSetUtil.close(rs);
        }
        ResultSetUtil.close(rs);
        return stringArray;
    }

    public static boolean isSupport(Connection con) {
        DatabaseMetaData objMet;
        block3: {
            try {
                objMet = con.getMetaData();
                if (DBType.getType(objMet) != 2 || objMet.getDatabaseMajorVersion() < 5) break block3;
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return objMet.supportsSchemasInTableDefinitions();
    }
}

