/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.ConstraintUtil;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Messages;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.TableFKColumn;
import zigen.plugin.db.core.TableHeaderElement;
import zigen.plugin.db.core.TableIDXColumn;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.rule.AbstractMappingFactory;
import zigen.plugin.db.core.rule.DefaultConstraintSearcherFactory;
import zigen.plugin.db.core.rule.DefaultSQLCreatorFactory;
import zigen.plugin.db.core.rule.IConstraintSearcherFactory;
import zigen.plugin.db.core.rule.IMappingFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.actions.MaxRecordException;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class TableManager {
    public static TableElement[] invoke(IDBConfig config, ITable table) throws Exception, MaxRecordException {
        int limit = DbPlugin.getDefault().getPreferenceStore().getInt("PreferencePage.MaxViewRecord");
        return TableManager.invoke(config, table, null, 0, limit);
    }

    public static TableElement[] invoke(IDBConfig config, ITable table, String condition) throws Exception, MaxRecordException {
        int limit = DbPlugin.getDefault().getPreferenceStore().getInt("PreferencePage.MaxViewRecord");
        return TableManager.invoke(config, table, condition, 0, limit);
    }

    public static TableElement[] invoke(IDBConfig config, ITable table, String condition, int offset, int limit) throws Exception, MaxRecordException {
        Connection con = Transaction.getInstance(config).getConnection();
        return TableManager.invoke(con, table, condition, offset, limit);
    }

    public static TableElement[] invoke(Connection con, ITable table) throws Exception, MaxRecordException {
        return TableManager.invoke(con, table, null);
    }

    public static TableElement[] invoke(Connection con, ITable table, String condition) throws Exception, MaxRecordException {
        int limit = DbPlugin.getDefault().getPreferenceStore().getInt("PreferencePage.MaxViewRecord");
        return TableManager.invoke(con, table, condition, 0, limit);
    }

    public static TableElement[] invoke(Connection con, ITable table, String condition, int offset, int limit) throws Exception, MaxRecordException {
        TableElement[] tableElementArray;
        ResultSet rs = null;
        Statement stmt = null;
        TablePKColumn[] pks = null;
        TableFKColumn[] fks = null;
        TableIDXColumn[] uidxs = null;
        try {
            IConstraintSearcherFactory factory;
            pks = table.getTablePKColumns();
            if (pks == null && (pks = (factory = DefaultConstraintSearcherFactory.getFactory(table.getDbConfig())).getPKColumns(con, table.getSchemaName(), table.getName())) == null) {
                uidxs = ConstraintUtil.getFirstUniqueIndex(table.getTableUIDXColumns());
            }
            fks = table.getTableFKColumns();
            stmt = con.createStatement();
            IDBConfig config = table.getDbConfig();
            ISQLCreatorFactory factory2 = DefaultSQLCreatorFactory.getFactory(config, table);
            String sql = TableManager.getSQL(factory2, condition, offset, limit);
            rs = stmt.executeQuery(sql);
            ResultSetMetaData meta = rs.getMetaData();
            ArrayList<TableElement> list = new ArrayList<TableElement>();
            TableColumn[] columns = TableManager.getTableColumns(meta, table);
            TableElement header = pks != null && pks.length > 0 ? TableManager.createHeaderElement(rs, table, columns, pks, fks) : TableManager.createHeaderElement(rs, table, columns, uidxs, fks);
            if (pks == null || pks.length == 0) {
                header.setCanModify(TableManager.checkModify(table.getDbConfig(), columns));
            } else {
                header.setCanModify(true);
            }
            list.add(header);
            int recordNo = 0;
            while (rs.next()) {
                TableElement elements;
                int no;
                ++recordNo;
                if (offset > 0 && factory2.isSupportPager()) {
                    no = recordNo + offset - 1;
                    elements = pks != null && pks.length > 0 ? TableManager.createElement(rs, table, columns, pks, no) : TableManager.createElement(rs, table, columns, uidxs, no);
                } else {
                    if (limit > 0 && recordNo > limit) {
                        String msg = Messages.getString("TableManager.0");
                        throw new MaxRecordException(msg, list.toArray(new TableElement[0]));
                    }
                    no = recordNo;
                    elements = pks != null && pks.length > 0 ? TableManager.createElement(rs, table, columns, pks, no) : TableManager.createElement(rs, table, columns, uidxs, no);
                }
                list.add(elements);
            }
            tableElementArray = list.toArray(new TableElement[0]);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw e;
            }
            catch (Throwable throwable) {
                ResultSetUtil.close(rs);
                StatementUtil.close(stmt);
                throw throwable;
            }
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(stmt);
        return tableElementArray;
    }

    private static String getSQL(ISQLCreatorFactory factory, String condition, int offset, int limit) {
        if (offset == 0 || !factory.isSupportPager()) {
            return factory.createSelect(condition, limit);
        }
        return factory.createSelectForPager(condition, offset, limit);
    }

    public static String getSQLForCSV(ITable table) {
        IDBConfig config = table.getDbConfig();
        ISQLCreatorFactory factory = DefaultSQLCreatorFactory.getFactory(config, table);
        return TableManager.getSQL(factory, null, 0, 0);
    }

    public static String getSQLForCSV(ITable table, String condition) {
        IDBConfig config = table.getDbConfig();
        ISQLCreatorFactory factory = DefaultSQLCreatorFactory.getFactory(config, table);
        return TableManager.getSQL(factory, condition, 0, 0);
    }

    static boolean checkModify(IDBConfig config, TableColumn[] columns) {
        IMappingFactory factory = AbstractMappingFactory.getFactory(config);
        int i = 0;
        while (i < columns.length) {
            TableColumn col = columns[i];
            if (!factory.canModifyDataType(col.getDataType())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TableColumn[] getTableColumns(ResultSetMetaData meta, ITable table) throws SQLException {
        try {
            ITable iTable = table;
            synchronized (iTable) {
                if (table.isExpanded()) {
                    int count = meta.getColumnCount();
                    Column[] cols = table.getColumns();
                    TableColumn[] columns = new TableColumn[cols.length];
                    int i = 0;
                    while (i < count) {
                        TableColumn column = new TableColumn();
                        column.setColumnName(meta.getColumnName(i + 1));
                        column.setTypeName(meta.getColumnTypeName(i + 1));
                        column.setDataType(meta.getColumnType(i + 1));
                        column.setColumnSize(meta.getColumnDisplaySize(i + 1));
                        column.setDecimalDigits(meta.getScale(i + 1));
                        if (meta.isNullable(i + 1) == 0) {
                            column.setNotNull(true);
                        } else {
                            column.setNotNull(false);
                        }
                        if (cols != null && cols.length > 0) {
                            column.setDefaultValue(cols[i].getDefaultValue());
                        }
                        if (columns != null && columns.length > 0) {
                            columns[i] = column;
                        }
                        ++i;
                    }
                    return columns;
                }
                int count = meta.getColumnCount();
                TableColumn[] columns = new TableColumn[count];
                int i = 0;
                while (i < count) {
                    TableColumn column = new TableColumn();
                    column.setColumnName(meta.getColumnName(i + 1));
                    column.setTypeName(meta.getColumnTypeName(i + 1));
                    column.setDataType(meta.getColumnType(i + 1));
                    column.setColumnSize(meta.getColumnDisplaySize(i + 1));
                    column.setDecimalDigits(meta.getScale(i + 1));
                    if (meta.isNullable(i + 1) == 0) {
                        column.setNotNull(true);
                    } else {
                        column.setNotNull(false);
                    }
                    columns[i] = column;
                    ++i;
                }
                return columns;
            }
        }
        catch (SQLException e) {
            DbPlugin.log(e);
            throw e;
        }
    }

    static TableElement createHeaderElement(ResultSet rs, ITable table, TableColumn[] columns, TablePKColumn[] pks, TableFKColumn[] fks) throws Exception {
        TableHeaderElement elements = null;
        int size = rs.getMetaData().getColumnCount();
        ArrayList<TableColumn> pkColumnList = new ArrayList<TableColumn>();
        int i = 0;
        while (i < size) {
            if (ConstraintUtil.isPKColumn(pks, columns[i].getColumnName())) {
                pkColumnList.add(columns[i]);
            }
            ++i;
        }
        if (pks.length == 0) {
            TableColumn[] uniqueColumns = new TableColumn[columns.length];
            System.arraycopy(columns, 0, uniqueColumns, 0, columns.length);
            elements = new TableHeaderElement(table, columns, uniqueColumns);
            elements.setCanModify(TableManager.checkModify(table.getDbConfig(), columns));
        } else {
            elements = new TableHeaderElement(table, columns, pkColumnList.toArray(new TableColumn[0]));
            elements.setCanModify(true);
            elements.setTablePKColumn(pks);
        }
        if (fks != null && fks.length > 0) {
            elements.setTableFKColumn(fks);
        }
        return elements;
    }

    static TableElement createElement(ResultSet rs, ITable table, TableColumn[] columns, TablePKColumn[] pks, int recordNo) throws Exception {
        TableElement elements = null;
        int size = rs.getMetaData().getColumnCount();
        Object[] items = new Object[size];
        ArrayList<TableColumn> pkColumnList = new ArrayList<TableColumn>();
        ArrayList<Object> pkItemList = new ArrayList<Object>();
        IMappingFactory factory = AbstractMappingFactory.getFactory(table.getDbConfig());
        int i = 0;
        while (i < size) {
            items[i] = factory.getObject(rs, i + 1);
            if (ConstraintUtil.isPKColumn(pks, columns[i].getColumnName())) {
                pkColumnList.add(columns[i]);
                pkItemList.add(items[i]);
            }
            ++i;
        }
        if (pks.length == 0) {
            TableColumn[] uniqueColumns = columns;
            Object[] uniqueItems = new Object[size];
            System.arraycopy(items, 0, uniqueItems, 0, size);
            elements = new TableElement(table, recordNo, columns, items, uniqueColumns, uniqueItems);
            elements.setCanModify(TableManager.checkModify(table.getDbConfig(), columns));
        } else {
            TableColumn[] uniqueColumns = pkColumnList.toArray(new TableColumn[0]);
            Object[] uniqueItems = new Object[pks.length];
            System.arraycopy(pkItemList.toArray(), 0, uniqueItems, 0, pks.length);
            elements = new TableElement(table, recordNo, columns, items, uniqueColumns, uniqueItems);
            elements.setCanModify(true);
        }
        return elements;
    }

    static TableElement createHeaderElement(ResultSet rs, ITable table, TableColumn[] columns, TableIDXColumn[] idxs, TableFKColumn[] fks) throws Exception {
        TableHeaderElement elements = null;
        rs.getMetaData().getColumnCount();
        ArrayList<TableColumn> uniqueColumnList = new ArrayList<TableColumn>();
        int i = 0;
        while (i < columns.length) {
            if (ConstraintUtil.isUniqueIDXColumn(idxs, columns[i].getColumnName())) {
                uniqueColumnList.add(columns[i]);
            }
            ++i;
        }
        if (idxs == null || idxs.length == 0) {
            TableColumn[] uniqueColumns = new TableColumn[columns.length];
            System.arraycopy(columns, 0, uniqueColumns, 0, columns.length);
            elements = new TableHeaderElement(table, columns, uniqueColumns);
            elements.setCanModify(TableManager.checkModify(table.getDbConfig(), columns));
        } else {
            elements = new TableHeaderElement(table, columns, uniqueColumnList.toArray(new TableColumn[0]));
            elements.setCanModify(true);
        }
        if (fks != null && fks.length > 0) {
            elements.setTableFKColumn(fks);
        }
        return elements;
    }

    static TableElement createElement(ResultSet rs, ITable table, TableColumn[] columns, TableIDXColumn[] idxs, int recordNo) throws Exception {
        TableElement elements = null;
        int size = rs.getMetaData().getColumnCount();
        Object[] items = new Object[size];
        ArrayList<TableColumn> uniqueColumnList = new ArrayList<TableColumn>();
        ArrayList<Object> uniqueItemList = new ArrayList<Object>();
        IMappingFactory factory = AbstractMappingFactory.getFactory(table.getDbConfig());
        int i = 0;
        while (i < size) {
            items[i] = factory.getObject(rs, i + 1);
            if (ConstraintUtil.isUniqueIDXColumn(idxs, columns[i].getColumnName())) {
                uniqueColumnList.add(columns[i]);
                uniqueItemList.add(items[i]);
            }
            ++i;
        }
        if (idxs == null || idxs.length == 0) {
            TableColumn[] uniqueColumns = columns;
            Object[] uniqueItems = new Object[size];
            System.arraycopy(items, 0, uniqueItems, 0, size);
            elements = new TableElement(table, recordNo, columns, items, uniqueColumns, uniqueItems);
            elements.setCanModify(TableManager.checkModify(table.getDbConfig(), columns));
        } else {
            TableColumn[] uniqueColumns = uniqueColumnList.toArray(new TableColumn[0]);
            Object[] uniqueItems = new Object[idxs.length];
            System.arraycopy(uniqueItemList.toArray(), 0, uniqueItems, 0, idxs.length);
            elements = new TableElement(table, recordNo, columns, items, uniqueColumns, uniqueItems);
            elements.setCanModify(true);
        }
        return elements;
    }
}

