/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.SchemaSearcher;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.core.TableInfoSorter;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleCommentInfo;
import zigen.plugin.db.ext.oracle.internal.OracleTableCommentsSearcher;

public class TableSearcher {
    public static synchronized TableInfo[] execute(IDBConfig config, String schemaPattern, String[] types) throws Exception {
        Connection con = Transaction.getInstance(config).getConnection();
        return TableSearcher.execute(con, schemaPattern, types);
    }

    private static Map getRemarks(Connection con, String schemaPattern) throws Exception {
        Map remarks = null;
        DatabaseMetaData objMet = con.getMetaData();
        switch (DBType.getType(objMet)) {
            case 1: {
                remarks = OracleTableCommentsSearcher.execute(con, schemaPattern);
            }
        }
        return remarks;
    }

    public static synchronized TableInfo[] execute(Connection con, String schemaPattern, String[] types) throws Exception {
        TableInfo[] tableInfoArray;
        ArrayList<TableInfo> list = new ArrayList<TableInfo>();
        ResultSet rs = null;
        Statement st = null;
        try {
            DatabaseMetaData objMet = con.getMetaData();
            Map remarks = TableSearcher.getRemarks(con, schemaPattern);
            if (DBType.getType(objMet) == 2 && objMet.getDatabaseMajorVersion() >= 5) {
                StringBuffer sb = new StringBuffer();
                sb.append("SELECT");
                sb.append("        TABLE_NAME");
                sb.append("        ,TABLE_TYPE");
                sb.append(" ,TABLE_COMMENT REMARKS");
                sb.append("    FROM");
                sb.append("        information_schema.TABLES");
                sb.append("    WHERE");
                sb.append("        TABLE_SCHEMA = '" + SQLUtil.encodeQuotation(schemaPattern) + "'");
                if (types.length > 0) {
                    sb.append("    AND (");
                    int i = 0;
                    while (i < types.length) {
                        if (i > 0) {
                            sb.append(" OR ");
                        }
                        sb.append("    TABLE_TYPE Like '%" + SQLUtil.encodeQuotation(types[i]) + "'");
                        ++i;
                    }
                    sb.append("    )");
                }
                st = con.createStatement();
                rs = st.executeQuery(sb.toString());
            } else {
                rs = SchemaSearcher.isSupport(con) ? objMet.getTables(null, schemaPattern, "%", types) : objMet.getTables(null, "%", "%", types);
            }
            list = new ArrayList();
            HashMap<String, String> map = new HashMap<String, String>();
            while (rs.next()) {
                OracleCommentInfo ora;
                String tableName = rs.getString("TABLE_NAME");
                if (map.containsKey(tableName)) continue;
                map.put(tableName, tableName);
                TableInfo info = new TableInfo();
                info.setName(tableName);
                info.setTableType(rs.getString("TABLE_TYPE"));
                info.setComment(rs.getString("REMARKS"));
                if (remarks != null && remarks.containsKey(tableName) && (ora = (OracleCommentInfo)remarks.get(tableName)) != null) {
                    info.setComment(ora.getRemarks());
                }
                list.add(info);
            }
            Collections.sort(list, new TableInfoSorter());
            tableInfoArray = list.toArray(new TableInfo[0]);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                StatementUtil.close(st);
                ResultSetUtil.close(rs);
                throw throwable;
            }
        }
        StatementUtil.close(st);
        ResultSetUtil.close(rs);
        return tableInfoArray;
    }

    public static TableInfo execute(Connection con, String schemaPattern, String tablePattern, String type) throws Exception {
        TableInfo tableInfo;
        TableInfo info = null;
        ResultSet rs = null;
        try {
            Map remarks = null;
            switch (DBType.getType(con.getMetaData())) {
                case 1: {
                    remarks = OracleTableCommentsSearcher.execute(con, schemaPattern);
                }
            }
            DatabaseMetaData objMet = con.getMetaData();
            rs = SchemaSearcher.isSupport(con) ? objMet.getTables(null, schemaPattern, tablePattern, new String[]{type}) : objMet.getTables(null, "%", tablePattern, new String[]{type});
            if (rs.next()) {
                OracleCommentInfo ora;
                String tableName = rs.getString("TABLE_NAME");
                info = new TableInfo();
                info.setName(tableName);
                info.setTableType(rs.getString("TABLE_TYPE"));
                info.setComment(rs.getString("REMARKS"));
                if (remarks != null && remarks.containsKey(tableName) && (ora = (OracleCommentInfo)remarks.get(tableName)) != null) {
                    info.setComment(ora.getRemarks());
                }
            }
            tableInfo = info;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                ResultSetUtil.close(rs);
                throw throwable;
            }
        }
        ResultSetUtil.close(rs);
        return tableInfo;
    }
}

