/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.rule.DefaultColumnSearcherFactory;
import zigen.plugin.db.core.rule.IColumnSearcherFactory;
import zigen.plugin.db.core.rule.mysql.MySQLColumnSearcharFactory;
import zigen.plugin.db.core.rule.oracle.OracleColumnSearcharFactory;

public abstract class AbstractColumnSearcherFactory
implements IColumnSearcherFactory {
    protected boolean convertUnicode;
    private static Map map = new HashMap();

    public static IColumnSearcherFactory getFactory(IDBConfig config) {
        return AbstractColumnSearcherFactory.getFactory(config.getDriverName(), config.isConvertUnicode());
    }

    public static IColumnSearcherFactory getFactory(DatabaseMetaData objMet, boolean isConvertUnicode) {
        try {
            return AbstractColumnSearcherFactory.getFactory(objMet.getDriverName(), isConvertUnicode);
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException("DriverName\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
    }

    public static IColumnSearcherFactory getFactory(String driverName, boolean isConvertUnicode) {
        IColumnSearcherFactory factory = null;
        String key = String.valueOf(driverName) + ":" + isConvertUnicode;
        if (map.containsKey(key)) {
            factory = (IColumnSearcherFactory)map.get(key);
            factory.setConvertUnicode(isConvertUnicode);
        } else {
            switch (DBType.getType(driverName)) {
                case 1: {
                    factory = new OracleColumnSearcharFactory(isConvertUnicode);
                    break;
                }
                case 2: {
                    factory = new MySQLColumnSearcharFactory(isConvertUnicode);
                    break;
                }
                default: {
                    factory = new DefaultColumnSearcherFactory(isConvertUnicode);
                }
            }
            map.put(key, factory);
        }
        return factory;
    }

    public void setConvertUnicode(boolean convertUnicode) {
        this.convertUnicode = convertUnicode;
    }
}

