/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.rule.DefaultSQLCreatorFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.core.rule.Messages;
import zigen.plugin.db.core.rule.db2.DB2SQLCreatorFactory;
import zigen.plugin.db.core.rule.derby.DerbySQLCreatorFactory;
import zigen.plugin.db.core.rule.h2.H2SQLCreatorFactory;
import zigen.plugin.db.core.rule.hsqldb.HSQLDBSQLCreatorFactory;
import zigen.plugin.db.core.rule.mysql.MySQLSQLCreatorFactory;
import zigen.plugin.db.core.rule.oracle.OracleSQLCreatorFactory;
import zigen.plugin.db.core.rule.postgresql.PostgreSQLSQLCreatorFactory;
import zigen.plugin.db.core.rule.sqlserver.SQLServerSQLCreatorFactory;
import zigen.plugin.db.core.rule.symfoware.SymfowareSQLCreatorFactory;
import zigen.plugin.db.ui.internal.ITable;

public abstract class AbstractSQLCreatorFactory
implements ISQLCreatorFactory {
    protected ITable table;
    private static Map map = new HashMap();

    public static final ISQLCreatorFactory getFactory(IDBConfig config, ITable table) {
        return AbstractSQLCreatorFactory.getFactory(config.getDriverName(), table);
    }

    public static final ISQLCreatorFactory getFactory(DatabaseMetaData objMet, ITable table) {
        try {
            return AbstractSQLCreatorFactory.getFactory(objMet.getDriverName(), table);
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException(Messages.getString("AbstractSQLCreatorFactory.Message1"));
        }
    }

    public static final ISQLCreatorFactory getFactoryNoCache(IDBConfig config, ITable table) {
        return AbstractSQLCreatorFactory.getFactoryNoCache(config.getDriverName(), table);
    }

    public static final ISQLCreatorFactory getFactoryNoCache(DatabaseMetaData objMet, ITable table) {
        try {
            return AbstractSQLCreatorFactory.getFactoryNoCache(objMet.getDriverName(), table);
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException(Messages.getString("AbstractSQLCreatorFactory.Message1"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ISQLCreatorFactory getFactory(String driverName, ITable table) {
        ISQLCreatorFactory factory = null;
        String key = driverName;
        if (map.containsKey(key)) {
            factory = (ISQLCreatorFactory)map.get(key);
            if (!(factory instanceof DefaultSQLCreatorFactory)) throw new IllegalStateException(Messages.getString("AbstractSQLCreatorFactory.Message2"));
            DefaultSQLCreatorFactory _factory = (DefaultSQLCreatorFactory)factory;
            _factory.setTable(table);
            return factory;
        } else {
            switch (DBType.getType(driverName)) {
                case 1: {
                    factory = new OracleSQLCreatorFactory(table);
                    break;
                }
                case 2: {
                    factory = new MySQLSQLCreatorFactory(table);
                    break;
                }
                case 9: {
                    factory = new PostgreSQLSQLCreatorFactory(table);
                    break;
                }
                case 3: {
                    factory = new SymfowareSQLCreatorFactory(table);
                    break;
                }
                case 10: {
                    factory = new DB2SQLCreatorFactory(table);
                    break;
                }
                case 11: {
                    factory = new SQLServerSQLCreatorFactory(table);
                    break;
                }
                case 8: {
                    factory = new H2SQLCreatorFactory(table);
                    break;
                }
                case 12: {
                    factory = new HSQLDBSQLCreatorFactory(table);
                    break;
                }
                case 6: {
                    factory = new DerbySQLCreatorFactory(table);
                    break;
                }
                default: {
                    factory = new DefaultSQLCreatorFactory(table);
                }
            }
            map.put(key, factory);
        }
        return factory;
    }

    public static final ISQLCreatorFactory getFactoryNoCache(String driverName, ITable table) {
        DefaultSQLCreatorFactory factory = null;
        switch (DBType.getType(driverName)) {
            case 1: {
                factory = new OracleSQLCreatorFactory(table);
                break;
            }
            case 2: {
                factory = new MySQLSQLCreatorFactory(table);
                break;
            }
            case 9: {
                factory = new PostgreSQLSQLCreatorFactory(table);
                break;
            }
            case 3: {
                factory = new SymfowareSQLCreatorFactory(table);
                break;
            }
            case 10: {
                factory = new DB2SQLCreatorFactory(table);
                break;
            }
            case 11: {
                factory = new SQLServerSQLCreatorFactory(table);
                break;
            }
            case 8: {
                factory = new H2SQLCreatorFactory(table);
                break;
            }
            case 12: {
                factory = new HSQLDBSQLCreatorFactory(table);
                break;
            }
            case 6: {
                factory = new DerbySQLCreatorFactory(table);
                break;
            }
            default: {
                factory = new DefaultSQLCreatorFactory(table);
            }
        }
        return factory;
    }

    protected void setDemiliter(StringBuffer sb) {
        String demiliter = DbPlugin.getDefault().getPreferenceStore().getString("SQLEditorPreferencePage.SqlDemiliter");
        if ("/".equals(demiliter)) {
            sb.append(DbPluginConstant.LINE_SEP);
        }
        sb.append(demiliter);
        sb.append(DbPluginConstant.LINE_SEP);
    }

    public abstract String createSelect(String var1, int var2);

    protected final String getViewDDL(IDBConfig config, String owner, String view) throws Exception {
        Statement st;
        ResultSet rs;
        block4: {
            String string;
            rs = null;
            st = null;
            try {
                Connection con = Transaction.getInstance(config).getConnection();
                st = con.createStatement();
                rs = st.executeQuery(this.getViewDDL_SQL(owner, view));
                if (!rs.next()) break block4;
                string = rs.getString(1);
            }
            catch (Exception e) {
                try {
                    DbPlugin.log(e);
                    throw e;
                }
                catch (Throwable throwable) {
                    ResultSetUtil.close(rs);
                    StatementUtil.close(st);
                    throw throwable;
                }
            }
            ResultSetUtil.close(rs);
            StatementUtil.close(st);
            return string;
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(st);
        return null;
    }

    abstract String getViewDDL_SQL(String var1, String var2);
}

