/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import zigen.plugin.db.core.JDBCUnicodeConvertor;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.rule.AbstractColumnSearcherFactory;
import zigen.plugin.db.core.rule.IColumnSearcherFactory;

public class DefaultColumnSearcherFactory
extends AbstractColumnSearcherFactory
implements IColumnSearcherFactory {
    public DefaultColumnSearcherFactory(boolean convertUnicode) {
        this.convertUnicode = convertUnicode;
    }

    public TableColumn[] execute(Connection con, String schemaPattern, String tableName) throws Exception {
        TableColumn[] tableColumnArray;
        ArrayList<TableColumn> list = new ArrayList<TableColumn>();
        ResultSet rs = null;
        Statement st = null;
        HashMap<String, TableColumn> map = new HashMap<String, TableColumn>();
        try {
            DatabaseMetaData objMet = con.getMetaData();
            rs = schemaPattern != null ? objMet.getColumns(null, schemaPattern, tableName, "%") : objMet.getColumns(null, "%", tableName, "%");
            int seq = 1;
            while (rs.next()) {
                TableColumn column = new TableColumn();
                column.setSeq(seq);
                column.setColumnName(rs.getString(4));
                column.setDataType(rs.getShort(5));
                column.setTypeName(rs.getString(6));
                column.setColumnSize(rs.getInt(7));
                column.setDecimalDigits(rs.getInt(9));
                String defaultValue = this.getDefaultValue(rs, this.convertUnicode);
                if (defaultValue != null) {
                    column.setDefaultValue(defaultValue);
                }
                String remarks = rs.getString("REMARKS");
                if (this.convertUnicode) {
                    remarks = JDBCUnicodeConvertor.convert(remarks);
                }
                column.setRemarks(remarks);
                if (rs.getInt(11) == 0) {
                    column.setNotNull(true);
                } else {
                    column.setNotNull(false);
                }
                map.put(column.getColumnName(), column);
                list.add(column);
                ++seq;
            }
            this.overrideColumnInfo(map, con, schemaPattern, tableName, this.convertUnicode);
            tableColumnArray = list.toArray(new TableColumn[0]);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                StatementUtil.close(st);
                ResultSetUtil.close(rs);
                throw throwable;
            }
        }
        StatementUtil.close(st);
        ResultSetUtil.close(rs);
        return tableColumnArray;
    }

    protected void overrideColumnInfo(Map map, Connection con, String schemaPattern, String tableName, boolean convUnicode) throws Exception {
    }

    protected String getDefaultValue(ResultSet rs, boolean convertUnicode) {
        String defaultValue = null;
        try {
            defaultValue = rs.getString("COLUMN_DEF");
            if (defaultValue != null) {
                defaultValue = defaultValue.trim();
            }
            if (convertUnicode) {
                return JDBCUnicodeConvertor.convert(defaultValue);
            }
        }
        catch (SQLException sQLException) {}
        return defaultValue;
    }
}

