/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.ConstraintNameSorter;
import zigen.plugin.db.core.ConstraintSeqSorter;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.TableConstraintColumn;
import zigen.plugin.db.core.TableFKColumn;
import zigen.plugin.db.core.TableIDXColumn;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.core.rule.AbstractConstraintSearcherFactory;
import zigen.plugin.db.core.rule.IConstraintSearcherFactory;

public class DefaultConstraintSearcherFactory
extends AbstractConstraintSearcherFactory
implements IConstraintSearcherFactory {
    public TablePKColumn[] getPKColumns(Connection con, String schemaPattern, String tableName) throws Exception {
        TablePKColumn[] tablePKColumnArray;
        ArrayList<TablePKColumn> list = new ArrayList<TablePKColumn>();
        ResultSet rs = null;
        Statement st = null;
        try {
            DatabaseMetaData objMet = con.getMetaData();
            rs = schemaPattern != null ? objMet.getPrimaryKeys(null, schemaPattern, tableName) : objMet.getPrimaryKeys(null, "%", tableName);
            int i = 0;
            while (rs.next()) {
                ++i;
                TablePKColumn column = new TablePKColumn();
                column.setSep(rs.getInt("KEY_SEQ"));
                column.setColumnName(rs.getString("COLUMN_NAME"));
                column.setName(rs.getString("PK_NAME"));
                list.add(column);
            }
            Collections.sort(list, new ConstraintSeqSorter());
            tablePKColumnArray = list.toArray(new TablePKColumn[0]);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw e;
            }
            catch (Throwable throwable) {
                StatementUtil.close(st);
                ResultSetUtil.close(rs);
                throw throwable;
            }
        }
        StatementUtil.close(st);
        ResultSetUtil.close(rs);
        return tablePKColumnArray;
    }

    /*
     * Loose catch block
     */
    public TableFKColumn[] getFKColumns(Connection con, String schemaPattern, String tableName) throws Exception {
        ArrayList<TableFKColumn> list = new ArrayList<TableFKColumn>();
        ResultSet rs = null;
        try {
            DatabaseMetaData objMet = con.getMetaData();
            rs = schemaPattern != null ? objMet.getImportedKeys(null, schemaPattern, tableName) : objMet.getImportedKeys(null, "%", tableName);
            while (rs.next()) {
                TableFKColumn column = new TableFKColumn();
                column.setSep(rs.getInt("KEY_SEQ"));
                column.setColumnName(rs.getString("FKCOLUMN_NAME"));
                column.setName(rs.getString("FK_NAME"));
                column.setPkSchema(rs.getString("PKTABLE_SCHEM"));
                column.setPkTableName(rs.getString("PKTABLE_NAME"));
                column.setPkColumnName(rs.getString("PKCOLUMN_NAME"));
                column.setPkName(rs.getString("PK_NAME"));
                int delRule = rs.getInt("DELETE_RULE");
                if (delRule == 0) {
                    column.setCasucade(true);
                } else {
                    column.setCasucade(false);
                }
                list.add(column);
            }
            Collections.sort(list, new ConstraintSeqSorter());
            Collections.sort(list, new ConstraintNameSorter());
            TableFKColumn[] tableFKColumnArray = list.toArray(new TableFKColumn[0]);
            ResultSetUtil.close(rs);
            return tableFKColumnArray;
        }
        catch (SQLException sQLException) {
            TableFKColumn[] tableFKColumnArray = new TableFKColumn[]{};
            return tableFKColumnArray;
        }
        catch (Exception e) {
            throw e;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ResultSetUtil.close(rs);
        }
    }

    /*
     * Loose catch block
     */
    public TableIDXColumn[] getUniqueIDXColumns(Connection con, String schemaPattern, String tableName, boolean unique) throws Exception {
        ArrayList<TableIDXColumn> list = new ArrayList<TableIDXColumn>();
        ResultSet rs = null;
        try {
            TimeWatcher tw = new TimeWatcher();
            tw.start();
            DatabaseMetaData objMet = con.getMetaData();
            rs = schemaPattern != null ? objMet.getIndexInfo(null, schemaPattern, tableName, unique, true) : objMet.getIndexInfo(null, "%", tableName, unique, true);
            tw.stop();
            while (rs.next()) {
                String indexName = rs.getString("INDEX_NAME");
                if (indexName == null) continue;
                TableIDXColumn column = new TableIDXColumn();
                column.setName(indexName);
                column.setOrdinal_position(rs.getInt("ORDINAL_POSITION"));
                column.setColumnName(rs.getString("COLUMN_NAME"));
                if (rs.getBoolean("NON_UNIQUE")) {
                    column.setNonUnique(true);
                } else {
                    column.setNonUnique(false);
                }
                column.setIndexType(DefaultConstraintSearcherFactory.getIndexTypeName(rs.getInt("TYPE")));
                list.add(column);
            }
            Collections.sort(list, new ConstraintSeqSorter());
            Collections.sort(list, new ConstraintNameSorter());
            TableIDXColumn[] tableIDXColumnArray = list.toArray(new TableIDXColumn[0]);
            ResultSetUtil.close(rs);
            return tableIDXColumnArray;
        }
        catch (SQLException e) {
            DbPlugin.log(e);
            TableIDXColumn[] tableIDXColumnArray = new TableIDXColumn[]{};
            return tableIDXColumnArray;
        }
        catch (Exception e2) {
            DbPlugin.log(e2);
            throw e2;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ResultSetUtil.close(rs);
        }
    }

    public TableConstraintColumn[] getConstraintColumns(Connection con, String schemaPattern, String tableName) throws Exception {
        return null;
    }
}

