/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule.db2;

import zigen.plugin.db.core.SQLFormatter;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.rule.DefaultSQLCreatorFactory;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class DB2SQLCreatorFactory
extends DefaultSQLCreatorFactory {
    public DB2SQLCreatorFactory(ITable table) {
        super(table);
    }

    public String createSelect(String _condition, int limit) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT * FROM ");
        sb.append(this.table.getSqlTableName());
        String[] conditions = SQLFormatter.splitOrderCause(_condition);
        String condition = conditions[0];
        String orderBy = conditions[1];
        sb.append(" WHERE 0 = 0");
        if (condition != null && !"".equals(condition.trim())) {
            sb.append(" AND " + condition);
        }
        if (orderBy != null && !"".equals(orderBy)) {
            sb.append(" " + orderBy);
        }
        if (limit > 0) {
            sb.append(" FETCH FIRST " + (limit + 1) + " ROWS ONLY");
        }
        return sb.toString();
    }

    public boolean supportsRemarks() {
        return true;
    }

    public boolean supportsModifyColumnType() {
        return false;
    }

    public boolean supportsModifyColumnSize(String columnType) {
        return this.isVisibleColumnSize(columnType);
    }

    public boolean supportsDropColumnCascadeConstraints() {
        return false;
    }

    public boolean supportsRollbackDDL() {
        return true;
    }

    public String createCommentOnTableDDL(String commnets) {
        StringBuffer sb = new StringBuffer();
        sb.append("COMMENT ON TABLE ");
        if (this.isVisibleSchemaName) {
            sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
        } else {
            sb.append(SQLUtil.encodeQuotation(this.table.getName()));
        }
        sb.append(" IS ");
        sb.append(" '" + SQLUtil.encodeQuotation(commnets) + "'");
        return sb.toString();
    }

    public String createCommentOnColumnDDL(Column column) {
        StringBuffer sb = new StringBuffer();
        sb.append("COMMENT ON COLUMN ");
        if (this.isVisibleSchemaName) {
            sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
        } else {
            sb.append(SQLUtil.encodeQuotation(this.table.getName()));
        }
        sb.append(".");
        sb.append(column.getName());
        sb.append(" IS");
        sb.append(" '" + SQLUtil.encodeQuotation(column.getRemarks()) + "'");
        return sb.toString();
    }

    public String createRenameTableDDL(String newTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("RENAME TABLE ");
        sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
        sb.append(" TO ");
        sb.append(SQLUtil.encodeQuotation(newTableName));
        return sb.toString();
    }

    public String createRenameColumnDDL(Column from, Column to) {
        return null;
    }

    public String[] createAddColumnDDL(Column column) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
        sb.append(" ADD ");
        sb.append(SQLUtil.encodeQuotation(column.getName()));
        sb.append(" ");
        sb.append(column.getTypeName());
        if (this.isVisibleColumnSize(column.getTypeName())) {
            sb.append("(");
            sb.append(column.getSize());
            sb.append(")");
        }
        if (column.getDefaultValue() != null && !"".equals(column.getDefaultValue())) {
            sb.append(" DEFAULT ");
            sb.append(column.getDefaultValue());
        }
        if (column.isNotNull()) {
            sb.append(" NOT NULL");
        }
        return new String[]{sb.toString()};
    }

    public String[] createModifyColumnDDL(Column from, Column to) {
        return null;
    }

    public String[] createDropColumnDDL(Column column, boolean cascadeConstraints) {
        return null;
    }

    public String createCreateIndexDDL(String indexName, Column[] columns, int indexType) {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE");
        if (1 == indexType) {
            sb.append(" UNIQUE");
        } else if (2 == indexType) {
            sb.append(" BITMAP");
        }
        sb.append(" INDEX ");
        sb.append("\"");
        sb.append(this.table.getSchemaName());
        sb.append("\"");
        sb.append(".");
        sb.append(indexName);
        sb.append(" ON ");
        if (this.isVisibleSchemaName) {
            sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
        } else {
            sb.append(SQLUtil.encodeQuotation(this.table.getName()));
        }
        sb.append("(");
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(column.getColumn().getColumnName());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public String createDropIndexDDL(String indexName) {
        StringBuffer sb = new StringBuffer();
        sb.append("DROP INDEX ");
        sb.append("\"");
        sb.append(this.table.getSchemaName());
        sb.append("\"");
        sb.append(".");
        sb.append(indexName);
        return sb.toString();
    }

    public String createCreateConstraintPKDDL(String constraintName, Column[] columns) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.table.getSqlTableName());
        sb.append(" ADD CONSTRAINT ");
        sb.append(constraintName);
        sb.append(" PRIMARY KEY");
        sb.append("(");
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(column.getColumn().getColumnName());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public String createCreateConstraintUKDDL(String constraintName, Column[] columns) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.table.getSqlTableName());
        sb.append(" ADD CONSTRAINT ");
        sb.append(constraintName);
        sb.append(" UNIQUE ");
        sb.append("(");
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(column.getColumn().getColumnName());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public String createCreateConstraintFKDDL(String constraintName, Column[] columns, ITable refTable, Column[] refColumns, boolean onDeleteCascade) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.table.getSqlTableName());
        sb.append(" ADD CONSTRAINT ");
        sb.append(constraintName);
        sb.append(" FOREIGN KEY");
        sb.append("(");
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(column.getColumn().getColumnName());
            ++i;
        }
        sb.append(")");
        sb.append(" REFERENCES ");
        sb.append(refTable.getSqlTableName());
        sb.append("(");
        i = 0;
        while (i < refColumns.length) {
            Column refColumn = refColumns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(refColumn.getColumn().getColumnName());
            ++i;
        }
        sb.append(")");
        if (onDeleteCascade) {
            sb.append(" ON DELETE CASCADE");
        }
        return sb.toString();
    }

    public String createCreateConstraintCheckDDL(String constraintName, String check) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.table.getSqlTableName());
        sb.append(" ADD CONSTRAINT ");
        sb.append(constraintName);
        sb.append(" CHECK");
        sb.append("(");
        sb.append(check);
        sb.append(")");
        return sb.toString();
    }

    public String createDropConstraintDDL(String constraintName, String type) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.table.getSqlTableName());
        sb.append(" DROP CONSTRAINT ");
        sb.append(constraintName);
        return sb.toString();
    }
}

