/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule.h2;

import zigen.plugin.db.core.SQLFormatter;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.rule.DefaultSQLCreatorFactory;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class H2SQLCreatorFactory
extends DefaultSQLCreatorFactory {
    public H2SQLCreatorFactory(ITable table) {
        super(table);
    }

    public String createSelect(String _condition, int limit) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT * FROM ");
        sb.append(this.table.getSqlTableName());
        String[] conditions = SQLFormatter.splitOrderCause(_condition);
        String condition = conditions[0];
        String orderBy = conditions[1];
        if (condition != null && !"".equals(condition.trim())) {
            sb.append(" WHERE ");
            sb.append(condition);
        }
        if (orderBy != null && !"".equals(orderBy)) {
            sb.append(" " + orderBy);
        }
        if (limit > 0) {
            sb.append(" LIMIT ");
            sb.append(limit + 1);
        }
        return sb.toString();
    }

    public boolean isSupportPager() {
        return true;
    }

    public String createSelectForPager(String _condition, int offset, int limit) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT * FROM ");
        sb.append(this.table.getSqlTableName());
        String[] conditions = SQLFormatter.splitOrderCause(_condition);
        String condition = conditions[0];
        String orderBy = conditions[1];
        if (condition != null && !"".equals(condition.trim())) {
            sb.append(" WHERE ");
            sb.append(condition);
        }
        if (orderBy != null && !"".equals(orderBy)) {
            sb.append(" " + orderBy);
        }
        if (limit > 0) {
            sb.append(" LIMIT ");
            sb.append(limit);
            sb.append(" OFFSET ");
            sb.append(offset - 1);
        }
        return sb.toString();
    }

    public String VisibleColumnSizePattern() {
        return ".*CHAR|^VARCHAR.*|^DECIMAL|^FLOAT|^DOUBLE|^REAL|^TIMESTAMP|^TIME|.*VARYING";
    }

    public String[] getSupportColumnType() {
        return new String[]{"INT", "BOOLEAN", "TINYINT", "SMALLINT", "BIGINT", "IDENTITY", "DECIMAL", "DOUBLE", "REAL", "TIME", "DATE", "TIMESTAMP", "BINARY", "OTHER", "VARCHAR", "VARCHAR_IGNORECASE", "BLOB", "CLOB"};
    }

    public boolean supportsRemarks() {
        return true;
    }

    public boolean supportsModifyColumnType() {
        return true;
    }

    public boolean supportsModifyColumnSize(String columnType) {
        return this.isVisibleColumnSize(columnType);
    }

    public boolean supportsDropColumnCascadeConstraints() {
        return false;
    }

    public boolean supportsRollbackDDL() {
        return false;
    }

    public String createCommentOnTableDDL(String commnets) {
        StringBuffer sb = new StringBuffer();
        sb.append("COMMENT ON TABLE ");
        if (this.isVisibleSchemaName) {
            sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
        } else {
            sb.append(SQLUtil.encodeQuotation(this.table.getName()));
        }
        sb.append(" IS ");
        sb.append(" '" + SQLUtil.encodeQuotation(commnets) + "'");
        return sb.toString();
    }

    public String createCommentOnColumnDDL(Column column) {
        StringBuffer sb = new StringBuffer();
        sb.append("COMMENT ON COLUMN ");
        if (this.isVisibleSchemaName) {
            sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
        } else {
            sb.append(SQLUtil.encodeQuotation(this.table.getName()));
        }
        sb.append(".");
        sb.append(column.getName());
        sb.append(" IS");
        sb.append(" '" + SQLUtil.encodeQuotation(column.getRemarks()) + "'");
        return sb.toString();
    }

    public String createRenameColumnDDL(Column from, Column to) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
        sb.append(" ALTER COLUMN ");
        sb.append(SQLUtil.encodeQuotation(from.getName()));
        sb.append(" RENAME TO ");
        sb.append(SQLUtil.encodeQuotation(to.getName()));
        return sb.toString();
    }

    public String[] createAddColumnDDL(Column column) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
        sb.append(" ADD COLUMN ");
        sb.append(SQLUtil.encodeQuotation(column.getName()));
        sb.append(" ");
        sb.append(column.getTypeName());
        if (this.isVisibleColumnSize(column.getTypeName())) {
            sb.append("(");
            sb.append(column.getSize());
            sb.append(")");
        }
        if (column.getDefaultValue() != null && !"".equals(column.getDefaultValue())) {
            sb.append(" DEFAULT ");
            sb.append(column.getDefaultValue());
        }
        if (column.isNotNull()) {
            sb.append(" NOT NULL");
        } else {
            sb.append(" NULL");
        }
        return new String[]{sb.toString()};
    }

    public String[] createDropColumnDDL(Column column, boolean cascadeConstraints) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
        sb.append(" DROP COLUMN ");
        sb.append(SQLUtil.encodeQuotation(column.getName()));
        return new String[]{sb.toString()};
    }

    public String[] createModifyColumnDDL(Column from, Column to) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
        sb.append(" ALTER COLUMN ");
        sb.append(SQLUtil.encodeQuotation(to.getName()));
        sb.append(" ");
        sb.append(to.getTypeName());
        if (this.isVisibleColumnSize(to.getTypeName())) {
            sb.append("(");
            sb.append(to.getSize());
            sb.append(")");
        }
        sb.append(" DEFAULT ");
        if ("".equals(to.getDefaultValue())) {
            sb.append("NULL");
        } else {
            sb.append(to.getDefaultValue());
        }
        if (to.isNotNull()) {
            sb.append(" NOT NULL");
        } else {
            sb.append(" NULL");
        }
        return new String[]{sb.toString()};
    }

    public String createRenameTableDDL(String newTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
        sb.append(" RENAME TO ");
        sb.append(SQLUtil.encodeQuotation(newTableName));
        return sb.toString();
    }

    public String createCreateIndexDDL(String indexName, Column[] columns, int indexType) {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE");
        if (1 == indexType) {
            sb.append(" UNIQUE");
        } else if (2 == indexType) {
            sb.append(" BITMAP");
        }
        sb.append(" INDEX ");
        sb.append("\"");
        sb.append(this.table.getSchemaName());
        sb.append("\"");
        sb.append(".");
        sb.append(indexName);
        sb.append(" ON ");
        if (this.isVisibleSchemaName) {
            sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
        } else {
            sb.append(SQLUtil.encodeQuotation(this.table.getName()));
        }
        sb.append("(");
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(column.getColumn().getColumnName());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public String createDropIndexDDL(String indexName) {
        StringBuffer sb = new StringBuffer();
        sb.append("DROP INDEX ");
        sb.append("\"");
        sb.append(this.table.getSchemaName());
        sb.append("\"");
        sb.append(".");
        sb.append(indexName);
        return sb.toString();
    }

    public String createCreateConstraintPKDDL(String constraintName, Column[] columns) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.table.getSqlTableName());
        sb.append(" ADD CONSTRAINT ");
        sb.append(constraintName);
        sb.append(" PRIMARY KEY");
        sb.append("(");
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(column.getColumn().getColumnName());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public String createCreateConstraintUKDDL(String constraintName, Column[] columns) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.table.getSqlTableName());
        sb.append(" ADD CONSTRAINT ");
        sb.append(constraintName);
        sb.append(" UNIQUE ");
        sb.append("(");
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(column.getColumn().getColumnName());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public String createCreateConstraintFKDDL(String constraintName, Column[] columns, ITable refTable, Column[] refColumns, boolean onDeleteCascade) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.table.getSqlTableName());
        sb.append(" ADD CONSTRAINT ");
        sb.append(constraintName);
        sb.append(" FOREIGN KEY");
        sb.append("(");
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(column.getColumn().getColumnName());
            ++i;
        }
        sb.append(")");
        sb.append(" REFERENCES ");
        sb.append(refTable.getSqlTableName());
        sb.append("(");
        i = 0;
        while (i < refColumns.length) {
            Column refColumn = refColumns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(refColumn.getColumn().getColumnName());
            ++i;
        }
        sb.append(")");
        if (onDeleteCascade) {
            sb.append(" ON DELETE CASCADE");
        }
        return sb.toString();
    }

    public String createCreateConstraintCheckDDL(String constraintName, String check) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.table.getSqlTableName());
        sb.append(" ADD CONSTRAINT ");
        sb.append(constraintName);
        sb.append(" CHECK");
        sb.append("(");
        sb.append(check);
        sb.append(")");
        return sb.toString();
    }

    public String createDropConstraintDDL(String constraintName, String type) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.table.getSqlTableName());
        if ("PRIMARY KEY".equals(type)) {
            sb.append(" DROP PRIMARY KEY ");
        } else {
            sb.append(" DROP CONSTRAINT ");
            sb.append(constraintName);
        }
        return sb.toString();
    }
}

