/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule.oracle;

import java.sql.Connection;
import java.util.Map;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.rule.DefaultColumnSearcherFactory;
import zigen.plugin.db.core.rule.oracle.OracleColumnInfo;
import zigen.plugin.db.core.rule.oracle.OracleColumnSearcher;

public class OracleColumnSearcharFactory
extends DefaultColumnSearcherFactory {
    public OracleColumnSearcharFactory(boolean convertUnicode) {
        super(convertUnicode);
    }

    protected void overrideColumnInfo(Map map, Connection con, String schemaPattern, String tableName, boolean convUnicode) throws Exception {
        OracleColumnInfo[] oraColumns = OracleColumnSearcher.execute(con, schemaPattern, tableName, convUnicode);
        int i = 0;
        while (i < oraColumns.length) {
            OracleColumnInfo oracleColumn = oraColumns[i];
            TableColumn tCol = (TableColumn)map.get(oracleColumn.getColumn_name());
            if (oracleColumn.getData_precision() == null) {
                tCol.setColumnSize(0);
                tCol.setDecimalDigits(0);
                tCol.setWithoutParam(true);
            } else {
                if (oracleColumn.getData_precision() != null) {
                    tCol.setColumnSize(oracleColumn.getData_precision().intValue());
                } else {
                    tCol.setColumnSize(0);
                }
                if (oracleColumn.getData_scale() != null) {
                    tCol.setDecimalDigits(oracleColumn.getData_scale().intValue());
                } else {
                    tCol.setDecimalDigits(0);
                }
                tCol.setWithoutParam(false);
            }
            if (oracleColumn.getData_default() != null) {
                tCol.setDefaultValue(oracleColumn.getData_default().trim());
            }
            tCol.setRemarks(oracleColumn.getComments());
            ++i;
        }
    }
}

