/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule.symfoware;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.SQLFormatter;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.rule.DefaultSQLCreatorFactory;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class SymfowareSQLCreatorFactory
extends DefaultSQLCreatorFactory {
    public SymfowareSQLCreatorFactory(ITable table) {
        super(table);
    }

    public String createSelect(String _condition, int limit) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT * FROM ");
        sb.append(this.table.getSqlTableName());
        String[] conditions = SQLFormatter.splitOrderCause(_condition);
        String condition = conditions[0];
        String orderBy = conditions[1];
        if (condition != null && !"".equals(condition.trim())) {
            sb.append(" WHERE " + condition);
        }
        if (orderBy != null && !"".equals(orderBy)) {
            sb.append(" " + orderBy);
        }
        if (!sb.toString().trim().endsWith("WITH OPTION LOCK_MODE(NL)")) {
            sb.append(" WITH OPTION LOCK_MODE(NL)");
        }
        return sb.toString();
    }

    public String createCountAll(String condition) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT COUNT(*) FROM ");
        sb.append(this.table.getSqlTableName());
        if (condition != null && !"".equals(condition.trim())) {
            sb.append(" WHERE " + condition);
        }
        sb.append(" WITH OPTION LOCK_MODE(NL)");
        return sb.toString();
    }

    public String createCountForQuery(String query) {
        StringBuffer sb = new StringBuffer();
        sb.append(super.createCountForQuery(query));
        sb.append(" WITH OPTION LOCK_MODE(NL)");
        return sb.toString();
    }

    protected String getCreateView() {
        StringBuffer wk = new StringBuffer();
        try {
            boolean onPatch = DbPlugin.getDefault().getPreferenceStore().getBoolean("SQLEditorPreferencePage.FormatPatch");
            int type = DbPlugin.getDefault().getPreferenceStore().getInt("SQLFormatPreferencePage.UseFormatterType");
            wk.append("CREATE VIEW ");
            if (this.isVisibleSchemaName) {
                wk.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
            } else {
                wk.append(SQLUtil.encodeQuotation(this.table.getName()));
            }
            wk.append(DbPluginConstant.LINE_SEP);
            wk.append("(");
            int i = 0;
            while (i < this.cols.length) {
                Column col = this.cols[i];
                if (i > 0) {
                    wk.append(",");
                }
                wk.append(col.getName());
                wk.append(DbPluginConstant.LINE_SEP);
                ++i;
            }
            wk.append(")");
            wk.append(DbPluginConstant.LINE_SEP);
            wk.append("AS");
            wk.append(DbPluginConstant.LINE_SEP);
            wk.append(this.getViewDDL(this.table.getDbConfig(), this.table.getSchemaName(), this.table.getName()));
            StringBuffer sb = new StringBuffer();
            sb.append(SQLFormatter.format(wk.toString(), type, onPatch));
            this.setDemiliter(sb);
            return sb.toString();
        }
        catch (Exception e) {
            DbPlugin.log(e);
            return null;
        }
    }

    protected String getViewDDL_SQL(String owner, String view) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT");
        sb.append("        D.DESC_VALUE");
        sb.append("    FROM");
        sb.append("        RDBII_SYSTEM.RDBII_TABLE T");
        sb.append("        ,RDBII_SYSTEM.RDBII_DESCRIPTION D");
        sb.append("    WHERE");
        sb.append("        T.TABLE_CODE = D.OBJECT_CODE");
        sb.append("        AND T.SCHEMA_NAME = '" + SQLUtil.encodeQuotation(owner) + "'");
        sb.append("        AND T.TABLE_NAME = '" + SQLUtil.encodeQuotation(view) + "'");
        sb.append("        AND T.TABLE_TYPE = 'VW'");
        return sb.toString();
    }

    public String[] createAddColumnDDL(Column column) {
        return null;
    }

    public String createCommentOnColumnDDL(Column column) {
        return null;
    }

    public String createCommentOnTableDDL(String commnets) {
        return null;
    }

    public String[] createDropColumnDDL(Column column, boolean cascadeConstraints) {
        return null;
    }

    public String[] createModifyColumnDDL(Column from, Column to) {
        return null;
    }

    public String createRenameColumnDDL(Column from, Column to) {
        return null;
    }

    public String createRenameTableDDL(String newTableName) {
        return null;
    }

    public boolean supportsModifyColumnSize(String columnType) {
        return false;
    }

    public boolean supportsModifyColumnType() {
        return false;
    }

    public boolean supportsRemarks() {
        return false;
    }

    public boolean supportsDropColumnCascadeConstraints() {
        return false;
    }
}

