/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.csv;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.csv.DefaultCsvMappingFactory;
import zigen.plugin.db.csv.ICsvMappingFactory;
import zigen.plugin.db.csv.OracleCsvMappingFactory;

public abstract class AbstractCsvMappingFactory
implements ICsvMappingFactory {
    protected SimpleDateFormat timeStampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected SimpleDateFormat timeStampFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected boolean convertUnicode;
    protected static final String NULL = "";
    protected String nullSymbol = DbPlugin.getDefault().getPreferenceStore().getString("PreferencePage.NullSymbol");
    protected boolean nonDoubleQuate;

    public static ICsvMappingFactory getFactory(IDBConfig config, boolean nonDoubleQuate) {
        return AbstractCsvMappingFactory.getFactory(config.getDriverName(), config.isConvertUnicode(), nonDoubleQuate);
    }

    public static ICsvMappingFactory getFactory(DatabaseMetaData objMet, boolean isConvertUnicode, boolean nonDoubleQuate) {
        try {
            return AbstractCsvMappingFactory.getFactory(objMet.getDriverName(), isConvertUnicode, nonDoubleQuate);
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException("DriverName\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
    }

    public static ICsvMappingFactory getFactory(String driverName, boolean isConvertUnicode, boolean nonDoubleQuate) {
        switch (DBType.getType(driverName)) {
            case 1: {
                return new OracleCsvMappingFactory(isConvertUnicode, nonDoubleQuate);
            }
        }
        return new DefaultCsvMappingFactory(isConvertUnicode, nonDoubleQuate);
    }

    protected String convertLineSep(String value) {
        if (value != null && value.length() > 0) {
            if (value.indexOf("\r\n") != -1) {
                value = value.replaceAll("\r\n", "\\\\n");
            } else if (value.indexOf("\n") != -1) {
                value = value.replaceAll("\n", "\\\\n");
            } else if (value.indexOf("\r") != -1) {
                value = value.replaceAll("\r", "\\\\n");
            }
        }
        return value;
    }

    public abstract String getCsvValue(ResultSet var1, int var2) throws Exception;

    protected Date toDate(String s) throws Exception {
        return Date.valueOf(s);
    }

    protected Time toTime(String s) throws Exception {
        return Time.valueOf(s);
    }

    protected Timestamp toTimestamp(String str) throws Exception {
        SimpleDateFormat df = null;
        java.util.Date date = null;
        df = str.length() <= 10 ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        date = df.parse(str);
        return new Timestamp(date.getTime());
    }

    protected Timestamp toTimestamp2(String str) throws Exception {
        SimpleDateFormat df = null;
        java.util.Date date = null;
        df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        date = df.parse(str);
        return new Timestamp(date.getTime());
    }

    protected byte[] toBytes(Object obj) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(obj);
        oos.flush();
        oos.close();
        bos.close();
        return bos.toByteArray();
    }

    protected String toBinary(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            String hx = Integer.toHexString(bytes[i] & 0xFF);
            String prefix = NULL;
            int j = hx.length();
            while (j < 2) {
                prefix = String.valueOf(prefix) + '0';
                ++j;
            }
            sb.append(prefix);
            sb.append(hx);
            ++i;
        }
        return sb.toString().toUpperCase();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] toByteArray(InputStream is) {
        ByteArrayOutputStream baos = null;
        byte[] buf = new byte[1024];
        int count = 0;
        baos = new ByteArrayOutputStream();
        while ((count = is.read(buf)) != -1) {
            if (count <= 0) continue;
            baos.write(buf, 0, count);
        }
        byte[] byArray = baos.toByteArray();
        if (baos == null) return byArray;
        try {
            baos.close();
            return byArray;
        }
        catch (IOException iOException) {}
        return byArray;
        catch (IOException e) {
            try {
                DbPlugin.log(e);
                if (baos == null) return null;
            }
            catch (Throwable throwable) {
                if (baos == null) throw throwable;
                try {
                    baos.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                baos.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
    }
}

