/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.diff;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.diff.IDDL;
import zigen.plugin.db.ext.oracle.internal.OracleSourceDetailInfo;
import zigen.plugin.db.ext.oracle.internal.OracleSourceDetailSearcher;
import zigen.plugin.db.ext.oracle.internal.OracleSourceInfo;
import zigen.plugin.db.ui.internal.OracleSource;

public class SourceDDL
implements IDDL,
Serializable {
    private static final long serialVersionUID = 1L;
    IDBConfig config = null;
    OracleSource oracleSource;
    OracleSourceInfo oracleSourceInfo;
    OracleSourceDetailInfo oracleSourceDetailInfo;
    String SqlSouceName;

    public SourceDDL() {
    }

    public SourceDDL(OracleSource oracleSource) {
        this.setOracleSource(oracleSource);
    }

    protected final OracleSourceDetailInfo getOracleSourceDetailInfo() {
        OracleSourceDetailInfo info = null;
        ResultSet rs = null;
        Statement st = null;
        try {
            try {
                Connection con = Transaction.getInstance(this.config).getConnection();
                String owner = this.oracleSourceInfo.getOwner();
                String name = this.oracleSourceInfo.getName();
                String type = this.oracleSourceInfo.getType();
                info = OracleSourceDetailSearcher.execute(con, owner, name, type, false);
            }
            catch (Exception e) {
                DbPlugin.log(e);
                ResultSetUtil.close(rs);
                StatementUtil.close(st);
            }
        }
        finally {
            ResultSetUtil.close(rs);
            StatementUtil.close(st);
        }
        return info;
    }

    public String getType() {
        return this.oracleSourceInfo.getType();
    }

    public String getDdl() {
        return this.oracleSourceDetailInfo != null ? this.oracleSourceDetailInfo.getText() : "";
    }

    public String getDbName() {
        return this.config.getDbName();
    }

    public String getDisplayedName() {
        return String.valueOf(this.getSchemaName()) + "." + this.getTargetName() + "[" + this.getType() + "]";
    }

    public String getSchemaName() {
        return this.oracleSourceInfo.getOwner();
    }

    public String getTargetName() {
        return this.oracleSourceInfo.getName();
    }

    public boolean isSchemaSupport() {
        return true;
    }

    public IDBConfig getConfig() {
        return this.config;
    }

    public void setConfig(IDBConfig config) {
        this.config = config;
    }

    public OracleSourceInfo getOracleSourceInfo() {
        return this.oracleSourceInfo;
    }

    public void setOracleSourceInfo(OracleSourceInfo oracleSourceInfo) {
        this.oracleSourceInfo = oracleSourceInfo;
    }

    public String getSqlSouceName() {
        return this.SqlSouceName;
    }

    public void setSqlSouceName(String sqlSouceName) {
        this.SqlSouceName = sqlSouceName;
    }

    public void setOracleSourceDetailInfo(OracleSourceDetailInfo oracleSourceDetailInfo) {
        this.oracleSourceDetailInfo = oracleSourceDetailInfo;
    }

    public OracleSource getOracleSource() {
        return this.oracleSource;
    }

    public void setOracleSource(OracleSource oracleSource) {
        this.oracleSource = oracleSource;
        this.config = oracleSource.getDbConfig();
        this.oracleSourceInfo = oracleSource.getOracleSourceInfo();
        this.oracleSourceDetailInfo = this.getOracleSourceDetailInfo();
    }
}

