/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.rule.DefaultColumnSearcherFactory;
import zigen.plugin.db.core.rule.IColumnSearcherFactory;
import zigen.plugin.db.ext.oracle.tablespace.OracleIndexColumn;
import zigen.plugin.db.ui.internal.ITable;

public class OracleIndexColumnSearcher {
    public static OracleIndexColumn[] execute(IDBConfig config, ITable table, String indexName) throws Exception {
        Connection con = Transaction.getInstance(config).getConnection();
        return OracleIndexColumnSearcher.execute(con, table, indexName, config.isConvertUnicode());
    }

    public static OracleIndexColumn[] execute(Connection con, ITable table, String indexName, boolean convertUnicode) throws Exception {
        OracleIndexColumn[] oracleIndexColumnArray;
        ResultSet rs = null;
        Statement st = null;
        try {
            ArrayList<OracleIndexColumn> list = new ArrayList<OracleIndexColumn>();
            st = con.createStatement();
            rs = st.executeQuery(OracleIndexColumnSearcher.getSql(table, indexName));
            String owner = table.getSchemaName();
            String tableName = table.getName();
            IDBConfig config = table.getDbConfig();
            IColumnSearcherFactory factory = DefaultColumnSearcherFactory.getFactory(config);
            TableColumn[] columns = factory.execute(con, owner, tableName);
            while (rs.next()) {
                OracleIndexColumn index = new OracleIndexColumn();
                index.setIndex_name(rs.getString("INDEX_NAME"));
                index.setTable_owner(rs.getString("TABLE_OWNER"));
                index.setTable_name(rs.getString("TABLE_NAME"));
                index.setColumn_name(rs.getString("COLUMN_NAME"));
                index.setColumn_position(rs.getInt("COLUMN_POSITION"));
                index.setColumn_position(rs.getInt("COLUMN_LENGTH"));
                OracleIndexColumnSearcher.setOptionInfo(columns, index);
                list.add(index);
            }
            oracleIndexColumnArray = list.toArray(new OracleIndexColumn[0]);
        }
        catch (Exception e) {
            try {
                DbPlugin.log(e);
                throw e;
            }
            catch (Throwable throwable) {
                ResultSetUtil.close(rs);
                StatementUtil.close(st);
                throw throwable;
            }
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(st);
        return oracleIndexColumnArray;
    }

    private static void setOptionInfo(TableColumn[] columns, OracleIndexColumn indexColumn) {
        int i = 0;
        while (i < columns.length) {
            TableColumn column = columns[i];
            if (column.getColumnName().equals(indexColumn.getColumn_name())) {
                indexColumn.setColumn_type(column.getTypeName());
                indexColumn.setColumn_length(column.getColumnSize());
                return;
            }
            ++i;
        }
        throw new IllegalStateException("setOptionInfo\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002(\u30ab\u30e9\u30e0\u540d\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093)");
    }

    private static String getSql(ITable table, String indexName) {
        String owner = table.getSchemaName();
        String tableName = table.getName();
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT");
        sb.append("         INDEX_NAME");
        sb.append("         ,TABLE_OWNER");
        sb.append("         ,TABLE_NAME");
        sb.append("         ,COLUMN_NAME");
        sb.append("         ,COLUMN_POSITION");
        sb.append("         ,COLUMN_LENGTH");
        sb.append("     FROM");
        sb.append("         all_ind_columns");
        sb.append("     WHERE");
        sb.append("         table_owner = '" + SQLUtil.encodeQuotation(owner) + "'");
        sb.append("     AND table_name = '" + SQLUtil.encodeQuotation(tableName) + "'");
        sb.append("     AND index_name = '" + SQLUtil.encodeQuotation(indexName) + "'");
        return sb.toString();
    }
}

