/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleSourceDetailInfo;

public class OracleSourceDetailSearcher {
    public static OracleSourceDetailInfo execute(IDBConfig config, String owner, String name, String type, boolean visibleSchema) throws Exception {
        Connection con = Transaction.getInstance(config).getConnection();
        return OracleSourceDetailSearcher.execute(con, owner, name, type, visibleSchema);
    }

    public static OracleSourceDetailInfo execute(Connection con, String owner, String name, String type, boolean visibleSchema) throws Exception {
        ResultSet rs = null;
        Statement st = null;
        OracleSourceDetailInfo info = null;
        try {
            try {
                st = con.createStatement();
                rs = st.executeQuery(OracleSourceDetailSearcher.getSQL(owner, name, type));
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (rs.next()) {
                    if (i == 0) {
                        info = new OracleSourceDetailInfo();
                        info.setOwner(rs.getString("OWNER"));
                        info.setName(rs.getString("NAME"));
                        info.setType(rs.getString("TYPE"));
                        String str = rs.getString("TEXT");
                        int pos = str.toUpperCase().indexOf(info.getName().toUpperCase());
                        if (visibleSchema) {
                            sb.append("CREATE OR REPLACE ").append(info.getType());
                            sb.append(" ").append(info.getOwner()).append(".");
                            sb.append(str.substring(pos));
                        } else {
                            sb.append("CREATE OR REPLACE ").append(info.getType());
                            sb.append(" ").append(str.substring(pos));
                        }
                    } else {
                        sb.append(rs.getString("TEXT"));
                    }
                    ++i;
                }
                if (info != null) {
                    info.setText(sb.toString());
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            ResultSetUtil.close(rs);
            StatementUtil.close(st);
            throw throwable;
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(st);
        return info;
    }

    private static String getSQL(String owner, String name, String type) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT");
        sb.append("         OWNER");
        sb.append("         ,NAME");
        sb.append("         ,TYPE");
        sb.append("         ,LINE");
        sb.append("         ,TEXT");
        sb.append("     FROM");
        sb.append("         ALL_SOURCE");
        sb.append("     WHERE");
        sb.append("         OWNER = '" + SQLUtil.encodeQuotation(owner) + "'");
        sb.append("         AND NAME = '" + SQLUtil.encodeQuotation(name) + "'");
        sb.append("         AND TYPE = '" + SQLUtil.encodeQuotation(type) + "'");
        sb.append("     ORDER BY LINE");
        return sb.toString();
    }
}

