/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.Transaction;

public class OracleSourceTypeSearcher {
    public static String[] execute(IDBConfig config, String owner) throws Exception {
        Connection con = Transaction.getInstance(config).getConnection();
        return OracleSourceTypeSearcher.execute(con, owner);
    }

    public static String[] execute(Connection con, String owner) throws Exception {
        ResultSet rs = null;
        Statement st = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            try {
                st = con.createStatement();
                rs = st.executeQuery(OracleSourceTypeSearcher.getSQL(owner));
                while (rs.next()) {
                    list.add(rs.getString("TYPE"));
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            ResultSetUtil.close(rs);
            StatementUtil.close(st);
            throw throwable;
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(st);
        return list.toArray(new String[0]);
    }

    private static String getSQL(String owner) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT");
        sb.append("         DISTINCT TYPE");
        sb.append("     FROM");
        sb.append("         ALL_SOURCE");
        sb.append("     WHERE");
        sb.append("         OWNER = '" + SQLUtil.encodeQuotation(owner) + "'");
        sb.append("     ORDER BY TYPE");
        return sb.toString();
    }
}

