/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleCommentInfo;

public class OracleTableCommentsSearcher {
    public static Map execute(IDBConfig config, String owner) throws Exception {
        Connection con = Transaction.getInstance(config).getConnection();
        return OracleTableCommentsSearcher.execute(con, owner);
    }

    public static Map execute(Connection con, String owner) throws Exception {
        HashMap<String, OracleCommentInfo> result = null;
        ResultSet rs = null;
        Statement st = null;
        try {
            try {
                st = con.createStatement();
                rs = st.executeQuery(OracleTableCommentsSearcher.getSQL(owner));
                result = new HashMap<String, OracleCommentInfo>();
                while (rs.next()) {
                    OracleCommentInfo info = new OracleCommentInfo();
                    info.setSchemaName(owner);
                    info.setTableName(rs.getString("TABLE_NAME"));
                    info.setRemarks(rs.getString("COMMENTS"));
                    result.put(info.getTableName(), info);
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            ResultSetUtil.close(rs);
            StatementUtil.close(st);
            throw throwable;
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(st);
        return result;
    }

    private static String getSQL(String owner) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT TABLE_NAME, COMMENTS");
        sb.append(" FROM ALL_TAB_COMMENTS");
        sb.append(" WHERE OWNER = '" + SQLUtil.encodeQuotation(owner) + "'");
        return sb.toString();
    }
}

