/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.Transaction;

public class OracleTypeSizeSearcher {
    public static HashMap execute(IDBConfig config) throws Exception {
        Connection con = Transaction.getInstance(config).getConnection();
        return OracleTypeSizeSearcher.execute(con);
    }

    public static HashMap execute(Connection con) throws Exception {
        HashMap<String, Integer> hashMap;
        ResultSet rs = null;
        Statement st = null;
        try {
            st = con.createStatement();
            rs = st.executeQuery(OracleTypeSizeSearcher.getSql());
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            while (rs.next()) {
                String type = rs.getString("TYPE");
                int size = rs.getInt("TYPE_SIZE");
                map.put(type, new Integer(size));
            }
            hashMap = map;
        }
        catch (Exception e) {
            try {
                DbPlugin.log(e);
                throw e;
            }
            catch (Throwable throwable) {
                ResultSetUtil.close(rs);
                StatementUtil.close(st);
                throw throwable;
            }
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(st);
        return hashMap;
    }

    private static String getSql() {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT");
        sb.append("         type");
        sb.append("         ,type_size");
        sb.append("     FROM");
        sb.append("         v$type_size");
        sb.append("     WHERE");
        sb.append("         type IN (");
        sb.append("             'KCBH'");
        sb.append("             ,'UB4'");
        sb.append("             ,'KTBBH'");
        sb.append("             ,'KTBIT'");
        sb.append("             ,'KDBH'");
        sb.append("             ,'KDBT'");
        sb.append("             ,'UB1'");
        sb.append("             ,'SB2'");
        sb.append("         )");
        return sb.toString();
    }
}

