/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.tablespace;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.List;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ext.oracle.tablespace.Messages;

public class CSVResultWriter {
    private char demiliter = (char)44;
    private boolean append = false;
    private String encording = Messages.getString("CSVResultWriter.0");
    private String[] headers = null;

    public CSVResultWriter() {
    }

    public CSVResultWriter(char demiliter) {
        this.demiliter = demiliter;
    }

    public CSVResultWriter(char demiliter, boolean append) {
        this.demiliter = demiliter;
        this.append = append;
    }

    public CSVResultWriter(char demiliter, boolean append, String encording) {
        this.demiliter = demiliter;
        this.append = append;
        this.encording = encording;
    }

    public void execute(File csvFile, List csvList) throws Exception {
        PrintStream pout = null;
        try {
            try {
                pout = new PrintStream((OutputStream)new FileOutputStream(csvFile, this.append), true, this.encording);
                if (!this.append) {
                    this.writeHeader(pout);
                }
                this.writeValue(pout, csvList);
            }
            catch (Exception e) {
                DbPlugin.log(e);
                throw e;
            }
        }
        finally {
            if (pout != null) {
                pout.close();
            }
        }
    }

    private void writeHeader(PrintStream pout) throws SQLException {
        int i = 0;
        while (i < this.headers.length) {
            String header = this.encode(this.headers[i]);
            if (i == this.headers.length - 1) {
                pout.println(header);
            } else {
                pout.print(String.valueOf(header) + this.demiliter);
            }
            ++i;
        }
    }

    private void writeValue(PrintStream pout, List csvList) throws SQLException {
        for (Object obj : csvList) {
            if (obj instanceof List) {
                List list = (List)obj;
                int i = 0;
                while (i < list.size()) {
                    String value = this.encode(list.get(i).toString());
                    if (i == list.size() - 1) {
                        pout.println(value);
                    } else {
                        pout.print(String.valueOf(value) + this.demiliter);
                    }
                    ++i;
                }
                continue;
            }
            throw new IllegalArgumentException("csvList\u306e\u4e2d\u8eab\u306fList\u578b\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059");
        }
    }

    private String encode(String value) {
        if ((value = value.replaceAll("\"", "\"\"")).indexOf("\"") > 0 || value.indexOf(",") > 0) {
            value = "\"" + value + "\"";
        }
        return value;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public char getDemiliter() {
        return this.demiliter;
    }

    public void setDemiliter(char demiliter) {
        this.demiliter = demiliter;
    }

    public String getEncording() {
        return this.encording;
    }

    public void setEncording(String encording) {
        this.encording = encording;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public void setHeaders(String[] headers) {
        this.headers = headers;
    }
}

