/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.tablespace.wizard;

import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ext.oracle.tablespace.wizard.DefaultWizardPage;
import zigen.plugin.db.ext.oracle.tablespace.wizard.IItem;
import zigen.plugin.db.ext.oracle.tablespace.wizard.Messages;
import zigen.plugin.db.ext.oracle.tablespace.wizard.TableItem;
import zigen.plugin.db.ext.oracle.tablespace.wizard.WizardPage1CellModifier;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.Schema;

public class WizardPage1
extends DefaultWizardPage {
    public static final String HEADER_TABLE = Messages.getString("WizardPage1.0");
    private String[] headers = new String[]{HEADER_TABLE};
    private ISelection selection;
    Schema schemaNode;
    ITable[] tableNodes;
    public static final String CHECKED_IMAGE = "checked";
    public static final String UNCHECKED_IMAGE = "unchecked";
    private static ImageRegistry imageRegistry = new ImageRegistry();

    static {
        String iconPath = "";
        imageRegistry.put(CHECKED_IMAGE, ImageDescriptor.createFromFile(WizardPage1.class, (String)(String.valueOf(iconPath) + CHECKED_IMAGE + ".gif")));
        imageRegistry.put(UNCHECKED_IMAGE, ImageDescriptor.createFromFile(WizardPage1.class, (String)(String.valueOf(iconPath) + UNCHECKED_IMAGE + ".gif")));
    }

    public WizardPage1(ISelection selection) {
        super("wizardPage");
        this.selection = selection;
        this.schemaNode = this.getSelectedSchema(selection);
        this.setTitle(Messages.getString("WizardPage1.2"));
        this.setDescription(Messages.getString("WizardPage1.3"));
        this.setPageComplete(false);
    }

    private Schema getSelectedSchema(ISelection _selection) {
        Object obj = ((StructuredSelection)_selection).getFirstElement();
        if (obj instanceof Schema) {
            return (Schema)obj;
        }
        return null;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(container, 0);
        label.setText(Messages.getString("WizardPage1.4"));
        this.createTable(container);
        this.setControl((Control)container);
    }

    private void createTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.HEIGHT_HINT;
        gridData.widthHint = this.WIDTH_HINT;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gridData);
        this.tableViewer = new TableViewer(composite, 68352);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.setHeaderColumn(table, this.headers);
        gridData = new GridData(1808);
        this.tableViewer.getControl().setLayoutData((Object)gridData);
        String[] properties = new String[]{"check"};
        this.tableViewer.setColumnProperties(properties);
        CellEditor[] editors = new CellEditor[]{new CheckboxCellEditor((Composite)table)};
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setCellModifier((ICellModifier)new WizardPage1CellModifier(this));
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.createTableItems();
        if (this.tableItems != null) {
            this.tableViewer.setInput((Object)this.tableItems);
            this.columnsPack(table);
        }
    }

    private void setHeaderColumn(Table table, String[] headers) {
        int i = 0;
        while (i < headers.length) {
            TableColumn col = new TableColumn(table, 0, i);
            col.setText(headers[i]);
            col.setResizable(true);
            col.pack();
            ++i;
        }
    }

    private void createTableItems() {
        try {
            zigen.plugin.db.ui.internal.Table[] tables = this.schemaNode.getTables();
            this.tableItems = new TableItem[tables.length];
            int i = 0;
            while (i < tables.length) {
                this.tableItems[i] = new TableItem(tables[i]);
                ++i;
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    boolean isSelected() {
        int i = 0;
        while (i < this.tableItems.length) {
            TableItem item = this.tableItems[i];
            if (item.isChecked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private List contents = null;

        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IItem[]) {
                return (TableItem[])inputElement;
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.contents = null;
        }

        public void dispose() {
            this.contents = null;
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        private Image getImage(boolean isSelected) {
            String key = isSelected ? WizardPage1.CHECKED_IMAGE : WizardPage1.UNCHECKED_IMAGE;
            return imageRegistry.get(key);
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            TableItem item = (TableItem)element;
            switch (columnIndex) {
                case 0: {
                    result = item.getTableName();
                    break;
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return columnIndex == 0 ? this.getImage(((TableItem)element).isChecked()) : null;
        }

        public Image getImage(Object obj) {
            return null;
        }
    }
}

