/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.ClipboardUtils;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.views.ColumnSearchAction;
import zigen.plugin.db.ui.views.TreeView;

public abstract class AbstractCopyStatementAction
implements IViewActionDelegate {
    protected ISelection selection = null;
    protected IViewPart viewPart;
    protected TreeViewer treeViewer;
    protected StringBuffer sb = null;

    public void init(IViewPart view) {
        this.viewPart = view;
        if (!(view instanceof TreeView)) {
            throw new RuntimeException("Required TreeView");
        }
        this.treeViewer = ((TreeView)view).getTreeViewer();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void run(IAction action) {
        try {
            if (this.selection instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)this.selection;
                new StringBuffer();
                new CopyAction((StructuredViewer)this.treeViewer, ss).run();
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private boolean checkLoadColumn(IStructuredSelection ss) {
        for (Object obj : ss) {
            ITable table;
            if (!(obj instanceof ITable) || (table = (ITable)obj).isExpanded()) continue;
            return false;
        }
        return true;
    }

    void setContents(String contents) {
        Clipboard clipboard = ClipboardUtils.getInstance();
        if (contents.length() > 0) {
            clipboard.setContents(new Object[]{contents}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    abstract String createStatement(ITable var1);

    class CopyAction
    extends Action {
        IStructuredSelection ss;
        StructuredViewer viewer;

        public CopyAction(StructuredViewer viewer, IStructuredSelection ss) {
            this.viewer = viewer;
            this.ss = ss;
        }

        public void run() {
            try {
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("Loading Column information...", CopyAction.this.ss.size());
                        ((CopyAction)CopyAction.this).AbstractCopyStatementAction.this.sb = new StringBuffer();
                        int i = 1;
                        Iterator iter = CopyAction.this.ss.iterator();
                        while (iter.hasNext()) {
                            if (monitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                            Object obj = iter.next();
                            if (obj instanceof ITable) {
                                ITable table = (ITable)obj;
                                monitor.subTask("Target : " + table + ", " + i + "/" + CopyAction.this.ss.size());
                                if (!table.isExpanded()) {
                                    table.setExpanded(true);
                                    new ColumnSearchAction(CopyAction.this.viewer, table).run();
                                }
                                ((CopyAction)CopyAction.this).AbstractCopyStatementAction.this.sb.append(AbstractCopyStatementAction.this.createStatement(table));
                            }
                            monitor.worked(1);
                            ++i;
                        }
                        monitor.done();
                        AbstractCopyStatementAction.this.setContents(((CopyAction)CopyAction.this).AbstractCopyStatementAction.this.sb.toString());
                    }
                };
                new ProgressMonitorDialog(DbPlugin.getDefault().getShell()).run(true, true, op);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                DbPlugin.getDefault().showInformationMessage("Copy was canceled.");
            }
        }
    }
}

