/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.ClipboardUtils;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.rule.DefaultStatementFactory;
import zigen.plugin.db.core.rule.IStatementFactory;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.actions.TableViewEditorAction;
import zigen.plugin.db.ui.internal.ITable;

public class CopyInsertStatementAction
extends TableViewEditorAction {
    private final String LINE_SEP = System.getProperty("line.separator");
    IStructuredSelection selection;

    public CopyInsertStatementAction() {
        this.setText(Messages.getString("CopyInsertStatementAction.1"));
        this.setToolTipText(Messages.getString("CopyInsertStatementAction.2"));
    }

    public void run() {
        try {
            StringBuffer sb = new StringBuffer();
            Clipboard clipboard = ClipboardUtils.getInstance();
            TextTransfer text_transfer = TextTransfer.getInstance();
            ITable table = this.editor.getTableNode();
            Iterator iter = this.selection.iterator();
            int index = 0;
            while (iter.hasNext()) {
                TableColumn col;
                Object obj = iter.next();
                if (!(obj instanceof TableElement)) continue;
                TableElement elem = (TableElement)obj;
                TableColumn[] columns = elem.getColumns();
                sb.append("INSERT INTO ");
                sb.append(table.getSqlTableName());
                sb.append(" (");
                int i = 0;
                while (i < columns.length) {
                    col = columns[i];
                    if (i == 0) {
                        sb.append(" ");
                    } else {
                        sb.append(", ");
                    }
                    sb.append(col.getColumnName());
                    ++i;
                }
                sb.append(" )");
                sb.append(" VALUES (");
                i = 0;
                while (i < columns.length) {
                    col = columns[i];
                    int type = col.getDataType();
                    Object value = elem.getItem(col);
                    IStatementFactory factory = DefaultStatementFactory.getFactory(table.getDbConfig());
                    if (i == 0) {
                        sb.append(factory.getString(type, value));
                    } else {
                        sb.append("," + factory.getString(type, value));
                    }
                    ++i;
                }
                sb.append(")" + this.LINE_SEP + "/" + this.LINE_SEP);
                ++index;
            }
            clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{text_transfer});
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    public void refresh() {
        if (this.editor == null) {
            this.setEnabled(false);
        } else if (this.editor.getViewer() == null) {
            this.setEnabled(false);
        } else {
            this.selection = (IStructuredSelection)this.editor.getViewer().getSelection();
            if (this.selection.size() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }
}

