/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.ClipboardUtils;
import zigen.plugin.db.core.SQLFormatter;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class CopySelectStatementAction
implements IViewActionDelegate {
    private ISelection selection = null;
    private IViewPart viewPart;
    boolean isSelectedColumn = false;

    public void init(IViewPart view) {
        this.viewPart = view;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void run(IAction action) {
        try {
            if (this.selection instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)this.selection;
                StringBuffer sb = new StringBuffer();
                int index = 0;
                String tableName = null;
                for (Object obj : ss) {
                    if (!this.isSelectedColumn && obj instanceof ITable) {
                        sb.append("SELECT * FROM ");
                        sb.append(((ITable)obj).getName());
                        this.copyString(sb.toString());
                        return;
                    }
                    if (!(obj instanceof Column)) continue;
                    this.isSelectedColumn = true;
                    Column col = (Column)obj;
                    tableName = col.getTable().getName();
                    if (index == 0) {
                        sb.append("SELECT ");
                        sb.append(tableName);
                        sb.append(".");
                        sb.append(col.getName());
                    } else {
                        sb.append(", ");
                        sb.append(tableName);
                        sb.append(".");
                        sb.append(col.getName());
                    }
                    ++index;
                }
                if (this.isSelectedColumn) {
                    sb.append(" FROM ").append(tableName);
                    this.copyString(sb.toString());
                }
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private void copyString(String sql) throws PartInitException {
        IPreferenceStore ps = DbPlugin.getDefault().getPreferenceStore();
        ps.getString("SQLEditorPreferencePage.SqlDemiliter");
        boolean onPatch = ps.getBoolean("SQLEditorPreferencePage.FormatPatch");
        int type = ps.getInt("SQLFormatPreferencePage.UseFormatterType");
        ps.getInt("SQLEditorPreferencePage.MaxSqlCount");
        sql = SQLFormatter.format(sql, type, onPatch);
        Clipboard clipboard = ClipboardUtils.getInstance();
        TextTransfer text_transfer = TextTransfer.getInstance();
        clipboard.setContents(new Object[]{sql}, new Transfer[]{text_transfer});
    }
}

