/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import java.sql.Connection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.ConnectionManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SQLInvoker;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.internal.ITable;

public class DeleteFromTableAction
extends Action
implements Runnable {
    public static final String SQL = "DELETE FROM ";
    private StructuredViewer viewer = null;

    public DeleteFromTableAction(StructuredViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.getString("DeleteFromTableAction.1"));
        this.setToolTipText(Messages.getString("DeleteFromTableAction.2"));
    }

    public void run() {
        Connection con = null;
        Object element = ((StructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (element instanceof ITable) {
            ITable table = (ITable)element;
            IDBConfig config = table.getDbConfig();
            try {
                try {
                    if (DbPlugin.getDefault().confirmDialog(Messages.getString("DeleteFromTableAction.3"))) {
                        con = ConnectionManager.getConnection(config);
                        con.setAutoCommit(false);
                        SQLInvoker.executeUpdate(con, SQL + table.getSqlTableName());
                        con.commit();
                    }
                }
                catch (Exception e) {
                    DbPlugin.getDefault().showErrorDialog(e);
                    ConnectionManager.closeConnection(con);
                }
            }
            finally {
                ConnectionManager.closeConnection(con);
            }
        }
    }
}

