/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.PlatformUI;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DropSQLInvoker;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.internal.OracleSequence;
import zigen.plugin.db.ui.internal.OracleSource;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.TreeNode;

public class DropTreeNodeAction
extends Action
implements Runnable {
    StructuredViewer viewer = null;

    public DropTreeNodeAction(StructuredViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.getString("DropTreeNodeAction.0"));
        this.setToolTipText(Messages.getString("DropTreeNodeAction.1"));
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
    }

    public void run() {
        try {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            for (Object obj : selection) {
                String name;
                String type;
                String owner;
                Schema schema;
                TreeNode parent;
                TreeNode elem;
                if (obj instanceof OracleSource) {
                    elem = (OracleSource)obj;
                    parent = elem.getParent();
                    schema = elem.getSchema();
                    owner = schema.getName();
                    type = ((OracleSource)elem).getType();
                    name = ((OracleSource)elem).getName();
                    if (!DbPlugin.getDefault().confirmDialog(String.valueOf(name) + Messages.getString("DropTreeNodeAction.2") + type + Messages.getString("DropTreeNodeAction.3"))) continue;
                    DropSQLInvoker.execute(elem.getDbConfig(), owner, type, name);
                    parent.removeChild(elem);
                    this.viewer.refresh((Object)parent);
                    continue;
                }
                if (!(obj instanceof OracleSequence)) continue;
                elem = (OracleSequence)obj;
                parent = elem.getParent();
                schema = elem.getSchema();
                owner = schema.getName();
                type = "SEQUENCE";
                name = ((OracleSequence)elem).getName();
                if (!DbPlugin.getDefault().confirmDialog(String.valueOf(name) + Messages.getString("DropTreeNodeAction.5") + type + Messages.getString("DropTreeNodeAction.6"))) continue;
                DropSQLInvoker.execute(elem.getDbConfig(), owner, type, name);
                parent.removeChild(elem);
                this.viewer.refresh((Object)parent);
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }
}

