/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.viewers.TableViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.StringUtil;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.TableNewElement;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.actions.TableViewEditorAction;
import zigen.plugin.db.ui.editors.internal.TableViewerManager;
import zigen.plugin.db.ui.internal.ITable;

public class InsertRecordAction
extends TableViewEditorAction {
    public InsertRecordAction() {
        this.setText(Messages.getString("InsertRecordAction.0"));
        this.setToolTipText(Messages.getString("InsertRecordAction.1"));
        this.setActionDefinitionId("zigen.plugin.InsertRecordCommand");
        this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("add.gif"));
    }

    public void run() {
        DbPlugin.getDefault().getPreferenceStore().getString("PreferencePage.NullSymbol");
        ITable table = this.editor.getTableNode();
        TableViewer viewer = this.editor.getViewer();
        TableElement elem = this.editor.getHeaderTableElement();
        int count = viewer.getTable().getItems().length;
        Object[] items = new Object[elem.getColumns().length];
        int i = 0;
        while (i < items.length) {
            TableColumn column = elem.getColumns()[i];
            items[i] = InsertRecordAction.getDefaultValue(column);
            ++i;
        }
        TableNewElement newElement = new TableNewElement(table, count + 1, elem.getColumns(), items, elem.getUniqueColumns());
        TableViewerManager.insert(viewer, newElement);
        this.editor.editTableElement(newElement, 1);
    }

    public static String getDefaultValue(TableColumn column) {
        String nullSymbol = DbPlugin.getDefault().getPreferenceStore().getString("PreferencePage.NullSymbol");
        String defaultValue = column.getDefaultValue();
        if (defaultValue != null && !"".equals(defaultValue)) {
            if (defaultValue.matches("^'.*'$")) {
                defaultValue = defaultValue.replaceAll("^'|'$", "");
                defaultValue = defaultValue.replaceAll("''", "'");
                return defaultValue;
            }
            if (defaultValue.matches("^\\(.*\\)$")) {
                if ((defaultValue = defaultValue.replaceAll("^\\(|\\)$", "")).matches("^'.*'$")) {
                    defaultValue = defaultValue.replaceAll("^'|'$", "");
                    defaultValue = defaultValue.replaceAll("''", "'");
                }
                return defaultValue;
            }
            if (defaultValue.equalsIgnoreCase("NULL")) {
                return nullSymbol;
            }
            if (StringUtil.isNumeric(defaultValue.trim())) {
                return defaultValue.trim();
            }
            return "";
        }
        if (!column.isNotNull()) {
            return nullSymbol;
        }
        return "";
    }
}

