/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import java.sql.Connection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.ConnectionManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SQLInvoker;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.jobs.RefreshFolderJob;

public class PurgeRecyclebinAction
extends Action
implements Runnable {
    public static final String SQL = "PURGE RECYCLEBIN";
    private TreeViewer viewer = null;

    public PurgeRecyclebinAction(TreeViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.getString("PurgeRecyclebinAction.1"));
        this.setToolTipText(Messages.getString("PurgeRecyclebinAction.2"));
    }

    public void run() {
        Connection con = null;
        Object element = ((StructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (element instanceof Schema) {
            Schema schema = (Schema)element;
            IDBConfig config = schema.getDbConfig();
            try {
                try {
                    if (DbPlugin.getDefault().confirmDialog(Messages.getString("PurgeRecyclebinAction.3"))) {
                        con = ConnectionManager.getConnection(config);
                        SQLInvoker.executeUpdate(con, SQL);
                        TreeLeaf leaf = schema.getChild("TABLE");
                        if (leaf instanceof Folder) {
                            RefreshFolderJob job = new RefreshFolderJob(this.viewer, (Folder)leaf);
                            job.setPriority(20);
                            job.schedule();
                        }
                    }
                }
                catch (Exception e) {
                    DbPlugin.getDefault().showErrorDialog(e);
                    ConnectionManager.closeConnection(con);
                }
            }
            finally {
                ConnectionManager.closeConnection(con);
            }
        }
    }
}

