/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.bookmark.BookmarkDialog;
import zigen.plugin.db.ui.internal.Bookmark;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.Table;
import zigen.plugin.db.ui.internal.TreeNode;
import zigen.plugin.db.ui.views.TreeContentProvider;

public class RegistBookmarkAction
extends Action
implements Runnable {
    TreeViewer viewer = null;

    public RegistBookmarkAction(TreeViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.getString("RegistBookmarkAction.0"));
        this.setToolTipText(Messages.getString("RegistBookmarkAction.1"));
    }

    public void run() {
        IContentProvider obj = this.viewer.getContentProvider();
        if (obj instanceof TreeContentProvider) {
            TreeContentProvider provider = (TreeContentProvider)obj;
            BookmarkDialog dialog = new BookmarkDialog(DbPlugin.getDefault().getShell(), provider);
            int ret = dialog.open();
            if (ret == 0) {
                TreeNode selectedNode = dialog.getSelectedNode();
                IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
                this.setBookmark(selection, selectedNode);
            }
        }
        this.viewer.refresh();
    }

    private void setBookmark(IStructuredSelection selection, TreeNode node) {
        for (Object object : selection) {
            if (!(object instanceof Table)) continue;
            Table table = (Table)object;
            Bookmark bm = new Bookmark(table);
            node.addChild(bm);
            if (bm.getChildren().size() != 0) continue;
            TableColumn tColumn = new TableColumn();
            tColumn.setColumnName(DbPluginConstant.TREE_LEAF_LOADING);
            bm.addChild(new Column(tColumn));
        }
    }
}

