/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBConfigManager;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.internal.Bookmark;
import zigen.plugin.db.ui.internal.BookmarkFolder;
import zigen.plugin.db.ui.internal.BookmarkRoot;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.views.TreeContentProvider;

public class RemoveDBAction
extends Action
implements Runnable {
    TreeViewer viewer = null;

    public RemoveDBAction(TreeViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.getString("RemoveDBAction.0"));
        this.setToolTipText(Messages.getString("RemoveDBAction.1"));
        this.setEnabled(true);
        this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("db_delete.gif"));
    }

    public void run() {
        IContentProvider cp;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        StringBuffer sb = new StringBuffer();
        sb.append(Messages.getString("RemoveDBAction.2"));
        sb.append(Messages.getString("RemoveDBAction.3"));
        if (DbPlugin.getDefault().confirmDialog(sb.toString()) && (cp = this.viewer.getContentProvider()) instanceof TreeContentProvider) {
            TreeContentProvider tcp = (TreeContentProvider)cp;
            BookmarkRoot bmroot = tcp.getBookmarkRoot();
            for (Object obj : selection) {
                if (!(obj instanceof DataBase)) continue;
                DataBase db = (DataBase)obj;
                this.removeBookmark(bmroot, db);
                DBConfigManager.remove(db.getDbConfig());
                db.getParent().removeChild(db);
                this.viewer.refresh();
                this.viewer.getControl().notifyListeners(13, null);
                DbPlugin.fireStatusChangeListener(db.getDbConfig(), 201);
            }
            DbPlugin.fireStatusChangeListener(this.viewer, 107);
        }
    }

    private void removeBookmark(BookmarkFolder folder, DataBase targetDataBase) {
        TreeLeaf[] leafs = folder.getChildrens();
        int i = 0;
        while (i < leafs.length) {
            TreeLeaf leaf = leafs[i];
            if (leaf instanceof Bookmark) {
                Bookmark bm = (Bookmark)leaf;
                if (bm.getDataBase().equals(targetDataBase)) {
                    folder.removeChild(bm);
                }
            } else if (leaf instanceof BookmarkFolder) {
                this.removeBookmark((BookmarkFolder)leaf, targetDataBase);
            }
            ++i;
        }
    }
}

