/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.actions.SQLSourceViewerAction;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;

public class SaveSQLAction
extends SQLSourceViewerAction {
    public SaveSQLAction(SQLSourceViewer viewer) {
        super(viewer);
        this.setText(Messages.getString("SaveSQLAction.0"));
        this.setToolTipText(Messages.getString("SaveSQLAction.1"));
        this.setImageDescriptor(DbPlugin.getDefault().getImageRegistry().getDescriptor("save.gif"));
    }

    public void run() {
        try {
            Shell shell = DbPlugin.getDefault().getShell();
            FileDialog dialog = new FileDialog(shell, 8192);
            if (this.fSQLSourceViewer.getSqlFileName() != null) {
                dialog.setFileName(this.fSQLSourceViewer.getSqlFileName());
            }
            dialog.setFilterExtensions(new String[]{"*.sql", "*.*"});
            dialog.setFilterNames(new String[]{Messages.getString("SaveSQLAction.3"), Messages.getString("SaveSQLAction.4")});
            String fileName = dialog.open();
            if (fileName == null) {
                return;
            }
            File file = new File(fileName);
            if (file.exists()) {
                MessageBox msg = new MessageBox(shell, 196);
                msg.setMessage(String.valueOf(fileName) + Messages.getString("SaveSQLAction.5"));
                msg.setText(Messages.getString("SaveSQLAction.6"));
                int res2 = msg.open();
                if (res2 == 128) {
                    return;
                }
            }
            this.write(fileName, this.fSQLSourceViewer.getDocument().get());
            this.fSQLSourceViewer.setSqlFile(file);
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    public void write(String fileName, String saveData) throws Exception {
        PrintStream pout = null;
        try {
            try {
                String charset = DbPlugin.getDefault().getPreferenceStore().getString("PreferencePage.SqlFileCharset");
                pout = new PrintStream((OutputStream)new FileOutputStream(fileName), true, charset);
                pout.print(saveData);
            }
            catch (Exception e) {
                DbPlugin.log(e);
                throw e;
            }
        }
        finally {
            if (pout != null) {
                pout.close();
            }
        }
    }
}

