/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.contentassist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ui.editors.TableViewEditorFor31;
import zigen.plugin.db.ui.editors.sql.ISqlEditor;
import zigen.plugin.db.ui.editors.sql.SqlEditor;
import zigen.plugin.db.ui.internal.ContentAssistTable;
import zigen.plugin.db.ui.views.ColumnSearchAction;
import zigen.plugin.db.ui.views.SQLExecuteView;
import zigen.plugin.db.ui.views.internal.SQLWhitespaceDetector;

public class ContentAssistUtil {
    public static boolean isAfterPeriod(IDocument document, int documentOffset) {
        try {
            char c = document.getChar(documentOffset - 1);
            return c == '.';
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public static String getPreviousWord(IDocument document, int documentOffset) {
        if (ContentAssistUtil.isAfterPeriod(document, documentOffset)) {
            --documentOffset;
        }
        SQLWhitespaceDetector whiteSpace = new SQLWhitespaceDetector();
        StringBuffer buf = new StringBuffer();
        try {
            while (true) {
                char c;
                if (whiteSpace.isWhitespace(c = document.getChar(--documentOffset)) || c == '.') {
                    return buf.reverse().toString();
                }
                buf.append(c);
            }
        }
        catch (BadLocationException badLocationException) {
            return buf.reverse().toString();
        }
    }

    public static String getPreviousWordGroup(IDocument document, int documentOffset) {
        if (ContentAssistUtil.isAfterPeriod(document, documentOffset)) {
            --documentOffset;
        }
        SQLWhitespaceDetector whiteSpace = new SQLWhitespaceDetector();
        StringBuffer buf = new StringBuffer();
        try {
            while (true) {
                char c;
                if (whiteSpace.isWhitespace(c = document.getChar(--documentOffset))) {
                    return buf.reverse().toString();
                }
                buf.append(c);
            }
        }
        catch (BadLocationException badLocationException) {
            return buf.reverse().toString();
        }
    }

    public static String subString(String modifier, int length) {
        if (modifier == null) {
            return null;
        }
        if (modifier.length() <= length) {
            return modifier;
        }
        return modifier.substring(0, length);
    }

    public static IDBConfig getIDBConfig() {
        IWorkbenchPart part;
        block6: {
            try {
                IWorkbenchPage page = DbPlugin.getDefault().getPage();
                part = page.getActivePart();
                if (!(part instanceof SqlEditor)) break block6;
                SqlEditor editorPart = (SqlEditor)part;
                if (editorPart instanceof ISqlEditor) {
                    return editorPart.getConfig();
                }
                return null;
            }
            catch (Exception e) {
                DbPlugin.log(e);
                return null;
            }
        }
        if (part instanceof SQLExecuteView) {
            SQLExecuteView viewPart = (SQLExecuteView)part;
            return viewPart.getConfig();
        }
        if (part instanceof TableViewEditorFor31) {
            TableViewEditorFor31 editor = (TableViewEditorFor31)part;
            return editor.getTableNode().getDbConfig();
        }
        throw new IllegalStateException("\u4e88\u5b9a\u3057\u3066\u3044\u306a\u3044\u51e6\u7406\u3067\u3059 part = " + part.getClass().getName());
    }

    public static ContentAssistTable createContentAssistTable(String schemaName, String tableName) {
        ContentAssistTable contentTable;
        Display display = Display.getDefault();
        IDBConfig config = ContentAssistUtil.getIDBConfig();
        switch (config.getDbType()) {
            case 1: {
                contentTable = new ContentAssistTable(config, schemaName, tableName.toUpperCase());
                display.syncExec((Runnable)new ColumnSearchAction(contentTable));
                break;
            }
            default: {
                contentTable = new ContentAssistTable(config, schemaName, tableName);
                display.syncExec((Runnable)new ColumnSearchAction(contentTable));
                if (contentTable.getColumns() != null && contentTable.getColumns().length != 0) break;
                contentTable = new ContentAssistTable(config, schemaName, tableName.toUpperCase());
                display.syncExec((Runnable)new ColumnSearchAction(contentTable));
                if (contentTable.getColumns() != null && contentTable.getColumns().length != 0) break;
                contentTable = new ContentAssistTable(config, schemaName, tableName.toLowerCase());
                display.syncExec((Runnable)new ColumnSearchAction(contentTable));
            }
        }
        return contentTable;
    }
}

