/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.contentassist;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SchemaInfo;
import zigen.plugin.db.core.SchemaSearcher;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.core.TableSearcher;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ui.actions.ConfirmConnectDBAction;
import zigen.plugin.db.ui.contentassist.ContentAssistUtil;
import zigen.plugin.db.ui.contentassist.ObjectCacher;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ContentAssistTable;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.TreeNode;
import zigen.plugin.db.ui.views.TreeView;

public class ContentInfo {
    IDBConfig config;
    Transaction trans;
    boolean isConnected = false;
    String currentSchema = null;
    Map schemaInfoMap = null;

    public ContentInfo(IDBConfig config) {
        this.config = config;
        if (config != null) {
            this.configure();
        } else {
            DbPlugin.log("ContentInfo\u306e\u751f\u6210\u51e6\u7406\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u63a5\u7d9a\u5b9a\u7fa9\u60c5\u5831\u304c\u3042\u308a\u307e\u305b\u3093");
        }
    }

    private void configure() {
        try {
            this.trans = Transaction.getInstance(this.config);
            if (this.trans.isConneting()) {
                this.isConnected = true;
                DbPlugin.fireStatusChangeListener(this.config, 106);
                this.schemaInfoMap = this.getSchemas();
                this.currentSchema = this.findCurrentSchema();
            } else {
                Display.getDefault().syncExec((Runnable)new ConfirmConnectDBAction(this.trans));
                if (this.trans.isConneting()) {
                    this.configure();
                } else {
                    this.isConnected = false;
                }
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    private String findCurrentSchema() throws Exception {
        DbPlugin.getDefault();
        TreeView tw = (TreeView)DbPlugin.findView("zigen.plugin.db.ui.views.TreeView");
        if (tw != null) {
            DataBase db = tw.getContentProvider().findDataBase(this.config);
            if (SchemaSearcher.isSupport(this.trans.getConnection())) {
                List list = db.getChildren();
                for (TreeNode node : list) {
                    if (node instanceof Schema) {
                        Schema schema = (Schema)node;
                        if (!schema.getName().equalsIgnoreCase(this.config.getSchema())) continue;
                        return schema.getName();
                    }
                    return null;
                }
            }
        } else {
            return this.findCorrectSchema(this.config.getSchema().toUpperCase());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getSchemas() throws Exception {
        ObjectCacher holder;
        HashMap<String, SchemaInfo> map = null;
        ObjectCacher objectCacher = holder = ObjectCacher.getInstance("@" + this.config.getDbName());
        synchronized (objectCacher) {
            map = (HashMap<String, SchemaInfo>)holder.get();
            if (map == null) {
                map = new HashMap<String, SchemaInfo>();
                try {
                    String[] result = SchemaSearcher.execute(this.trans.getConnection());
                    int i = 0;
                    while (i < result.length) {
                        String schema = result[i];
                        SchemaInfo info = new SchemaInfo(this.config, schema);
                        map.put(schema.toUpperCase(), info);
                        ++i;
                    }
                }
                catch (Exception e) {
                    DbPlugin.log(e);
                }
                holder.put(map);
            }
        }
        return map;
    }

    public TableInfo[] getTableInfo() throws Exception {
        return this.getTableInfo(this.currentSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableInfo[] getTableInfo(String schema) throws Exception {
        ObjectCacher holder;
        if (this.config == null) {
            return null;
        }
        String[] tableTypes = null;
        switch (this.config.getDbType()) {
            case 1: {
                tableTypes = new String[]{"TABLE", "VIEW", "SYNONYM"};
                break;
            }
            default: {
                tableTypes = new String[]{"TABLE", "VIEW"};
            }
        }
        TableInfo[] result = null;
        String keySchemaName = schema != null ? schema : this.config.getDbName();
        ObjectCacher objectCacher = holder = ObjectCacher.getInstance(String.valueOf(keySchemaName) + "@" + this.config.getDbName());
        synchronized (objectCacher) {
            result = (TableInfo[])holder.get();
            if (result == null) {
                try {
                    result = schema != null ? TableSearcher.execute(this.trans.getConnection(), schema, tableTypes) : TableSearcher.execute(this.trans.getConnection(), null, tableTypes);
                }
                catch (Exception e) {
                    DbPlugin.log(e);
                }
                holder.put(result);
            }
        }
        return result;
    }

    public Column[] getColumns(String tableName) {
        return this.getColumns(this.currentSchema, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Column[] getColumns(String schemaName, String tableName) {
        ObjectCacher holder;
        Column[] result = null;
        ObjectCacher objectCacher = holder = ObjectCacher.getInstance(String.valueOf(tableName) + "@" + schemaName + "@" + this.config.getDbName());
        synchronized (objectCacher) {
            result = (Column[])holder.get();
            if (result == null) {
                ContentAssistTable table = ContentAssistUtil.createContentAssistTable(schemaName, tableName);
                result = table.getColumns();
                holder.put(result);
            }
        }
        return result;
    }

    public String findCorrectSchema(String target) {
        SchemaInfo info = (SchemaInfo)this.schemaInfoMap.get(target.toUpperCase());
        if (info != null) {
            return info.getName();
        }
        return null;
    }

    public String getCurrentSchema() {
        return this.currentSchema;
    }

    public IDBConfig getConfig() {
        return this.config;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public SchemaInfo[] getSchemaInfos() {
        if (this.schemaInfoMap == null) {
            return null;
        }
        SchemaInfo[] infos = new SchemaInfo[this.schemaInfoMap.size()];
        int i = 0;
        for (String key : this.schemaInfoMap.keySet()) {
            infos[i++] = (SchemaInfo)this.schemaInfoMap.get(key);
        }
        return infos;
    }
}

