/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.swt.graphics.Image;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.DbPluginFormatRule;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.core.StringUtil;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.parser.util.ASTUtil2;
import zigen.plugin.db.parser.util.CurrentSql;
import zigen.plugin.db.preference.SQLTemplateEditorUI;
import zigen.plugin.db.ui.contentassist.ContentAssistUtil;
import zigen.plugin.db.ui.contentassist.ProcessorInfo;
import zigen.plugin.db.ui.contentassist.SQLProposalCreator2;
import zigen.plugin.db.ui.contentassist.SQLTemplateContext;
import zigen.plugin.db.ui.contentassist.SQLTemplateProposal;
import zigen.plugin.db.ui.contentassist.processor.DefaultProcessor;
import zigen.plugin.db.ui.contentassist.processor.DeleteProcessor;
import zigen.plugin.db.ui.contentassist.processor.DropProcessor;
import zigen.plugin.db.ui.contentassist.processor.InsertProcessor;
import zigen.plugin.db.ui.contentassist.processor.SelectProcessor;
import zigen.plugin.db.ui.contentassist.processor.UpdateProcessor;
import zigen.sql.parser.ASTVisitor2;
import zigen.sql.parser.INode;
import zigen.sql.parser.IVisitor;
import zigen.sql.parser.SqlParser;
import zigen.sql.parser.ast.ASTDeleteStatement;
import zigen.sql.parser.ast.ASTDropStatement;
import zigen.sql.parser.ast.ASTInsertStatement;
import zigen.sql.parser.ast.ASTRoot;
import zigen.sql.parser.ast.ASTSelectStatement;
import zigen.sql.parser.ast.ASTUpdateStatement;
import zigen.sql.parser.exception.ParserException;

public class SQLContentAssistantProcessor2
extends TemplateCompletionProcessor
implements IContentAssistProcessor {
    private static final Comparator fgProposalComparator = new ProposalComparator();
    private int current = -1;
    private int scope = -1;
    private INode currentNode = null;
    private IPreferenceStore preferenceStore;
    private DbPluginFormatRule rule;
    private Object lock = new Object();
    boolean isSQLParsing = false;
    public static String[] SQL_OPERATOR = new String[]{"=", "<", ">", "IS NULL", "IS NOT NULL", "LIKE", "IN", "EXIST", "(+)", "||", "<=", ">=", "<>", "(", ")", "+", "-", "*", "/"};

    public SQLContentAssistantProcessor2() {
        this.preferenceStore = DbPlugin.getDefault().getPreferenceStore();
        this.rule = DbPluginFormatRule.getInstance();
    }

    private void parseSql(IDocument doc, int offset, ProcessorInfo pinfo, String demiliter) throws SQLParserTimeout {
        block12: {
            Object parser = null;
            Object visitor = null;
            try {
                this.currentNode = null;
                int timeout = 1;
                SQLParseThread t = new SQLParseThread(doc, offset, demiliter);
                Thread th = new Thread(t);
                th.setPriority(1);
                th.start();
                try {
                    if (timeout > 0) {
                        th.join(timeout * 1000);
                    } else {
                        th.join();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (t.isComplete()) {
                    pinfo.setCurrentNode(this.currentNode);
                    if (this.currentNode != null) {
                        pinfo.setCurrentScope(this.currentNode.getScope());
                    } else {
                        pinfo.setCurrentScope(0);
                    }
                    break block12;
                }
                this.currentNode = null;
                pinfo.setCurrentNode(this.currentNode);
                pinfo.setCurrentScope(0);
                throw new SQLParserTimeout("SQL Parse is timeout.");
            }
            finally {
                if (parser != null) {
                    parser = null;
                }
                if (visitor != null) {
                    visitor = null;
                }
            }
        }
    }

    private INode findCurrentNode(ASTVisitor2 visitor, String offsetSql) {
        int nodeOffset = StringUtil.endWordPosition(offsetSql);
        INode node = visitor.findNodeByOffset(nodeOffset);
        if (node != null) {
            return node;
        }
        return this.findCurrentNode(visitor, offsetSql.substring(0, nodeOffset));
    }

    private void addTemplateProposal(List proposals, ICompletionProposal[] templates, ProcessorInfo pinfo) {
        if (templates != null) {
            String word = pinfo.getWord();
            if (pinfo.isAfterPeriod()) {
                word = "";
            }
            int len = word.length();
            int i = 0;
            while (i < templates.length) {
                ICompletionProposal template = templates[i];
                String str = template.getDisplayString();
                String value = ContentAssistUtil.subString(str, len);
                if (value != null && value.compareToIgnoreCase(word) == 0) {
                    proposals.add(template);
                }
                ++i;
            }
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ProcessorInfo pinfo;
        IDocument doc;
        String demiliter;
        String mode;
        ArrayList proposals;
        block17: {
            proposals = new ArrayList();
            mode = this.preferenceStore.getString("CodeAssistPreferencePage.SqlCodeAssitModde");
            demiliter = this.preferenceStore.getString("SQLEditorPreferencePage.SqlDemiliter");
            doc = viewer.getDocument();
            pinfo = new ProcessorInfo();
            pinfo.setAfterPeriod(ContentAssistUtil.isAfterPeriod(doc, offset));
            pinfo.setOffset(offset);
            pinfo.setWord(ContentAssistUtil.getPreviousWord(doc, offset).toLowerCase());
            pinfo.setWordGroup(ContentAssistUtil.getPreviousWordGroup(doc, offset).toLowerCase());
            if (!mode.equals("0")) break block17;
            return null;
        }
        try {
            if (mode.equals("1")) {
                SQLProposalCreator2.addProposal(proposals, this.rule.getKeywordNames(), pinfo);
                SQLProposalCreator2.addProposalForFunction(proposals, this.rule.getFunctionNames(), pinfo);
            } else if (mode.equals("2")) {
                try {
                    DefaultProcessor p;
                    this.parseSql(doc, offset, pinfo, demiliter);
                    INode st = null;
                    st = ASTUtil2.findParent(this.currentNode, "ASTSelectStatement");
                    if (st != null) {
                        p = new SelectProcessor(proposals, pinfo);
                        ((SelectProcessor)p).createProposals((ASTSelectStatement)st);
                    } else {
                        st = ASTUtil2.findParent(this.currentNode, "ASTInsertStatement");
                        if (st != null) {
                            p = new InsertProcessor(proposals, pinfo);
                            ((InsertProcessor)p).createProposals((ASTInsertStatement)st);
                        } else {
                            st = ASTUtil2.findParent(this.currentNode, "ASTUpdateStatement");
                            if (st != null) {
                                p = new UpdateProcessor(proposals, pinfo);
                                ((UpdateProcessor)p).createProposals((ASTUpdateStatement)st);
                            } else {
                                st = ASTUtil2.findParent(this.currentNode, "ASTDeleteStatement");
                                if (st != null) {
                                    p = new DeleteProcessor(proposals, pinfo);
                                    ((DeleteProcessor)p).createProposals((ASTDeleteStatement)st);
                                } else {
                                    st = ASTUtil2.findParent(this.currentNode, "ASTDropStatement");
                                    if (st != null) {
                                        p = new DropProcessor(proposals, pinfo);
                                        ((DropProcessor)p).createProposals((ASTDropStatement)st);
                                    }
                                }
                            }
                        }
                    }
                }
                catch (SQLParserTimeout sQLParserTimeout) {
                    SQLProposalCreator2.addProposal(proposals, this.rule.getKeywordNames(), pinfo);
                }
            }
            ICompletionProposal[] templates = super.computeCompletionProposals(viewer, offset);
            this.addTemplateProposal(proposals, templates, pinfo);
            ICompletionProposal[] tFunctions = this.computeCompletionProposalsForFunction(viewer, offset);
            this.addTemplateProposal(proposals, tFunctions, pinfo);
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
        return proposals.toArray(new ICompletionProposal[0]);
    }

    protected TemplateContext createContext(ITextViewer viewer, IRegion region) {
        TemplateContextType contextType = this.getContextType(viewer, region);
        if (contextType != null) {
            IDocument document = viewer.getDocument();
            return new SQLTemplateContext(contextType, document, region.getOffset(), region.getLength());
        }
        return null;
    }

    public ICompletionProposal[] computeCompletionProposalsForFunction(ITextViewer viewer, int offset) {
        String prefix;
        Region region;
        TemplateContext context;
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        if (selection.getOffset() == offset) {
            offset = selection.getOffset() + selection.getLength();
        }
        if ((context = this.createContextForFunction(viewer, (IRegion)(region = new Region(offset - (prefix = this.extractPrefix(viewer, offset)).length(), prefix.length())))) == null) {
            return new ICompletionProposal[0];
        }
        context.setVariable("selection", selection.getText());
        Template[] templates = this.getTemplates(context.getContextType().getId());
        ArrayList<ICompletionProposal> matches = new ArrayList<ICompletionProposal>();
        int i = 0;
        while (i < templates.length) {
            block6: {
                Template template = templates[i];
                try {
                    context.getContextType().validate(template.getPattern());
                }
                catch (TemplateException templateException) {
                    break block6;
                }
                if (template.matches(prefix, context.getContextType().getId())) {
                    matches.add(this.createProposalForFunction(template, context, (IRegion)region, this.getRelevance(template, prefix)));
                }
            }
            ++i;
        }
        Collections.sort(matches, fgProposalComparator);
        return matches.toArray(new ICompletionProposal[matches.size()]);
    }

    protected TemplateContext createContextForFunction(ITextViewer viewer, IRegion region) {
        TemplateContextType contextType = this.getContextTypeForFunction(viewer, region);
        if (contextType != null) {
            IDocument document = viewer.getDocument();
            return new SQLTemplateContext(contextType, document, region.getOffset(), region.getLength());
        }
        return null;
    }

    protected TemplateContextType getContextTypeForFunction(ITextViewer viewer, IRegion region) {
        return SQLTemplateEditorUI.getDefault().getContextTypeRegistry().getContextType("zigen.plugin.db.template.sql.function");
    }

    protected ICompletionProposal createProposalForFunction(Template template, TemplateContext context, IRegion region, int relevance) {
        return new SQLTemplateProposal(template, context, region, this.getImageForFunction(template), relevance);
    }

    protected Image getImageForFunction(Template template) {
        ImageCacher ic = ImageCacher.getInstance();
        return ic.getImage("function.gif");
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    protected Template[] getTemplates(String contextTypeId) {
        return SQLTemplateEditorUI.getDefault().getTemplateStore().getTemplates();
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return SQLTemplateEditorUI.getDefault().getContextTypeRegistry().getContextType("zigen.plugin.db.template.sql");
    }

    protected Image getImage(Template template) {
        ImageCacher ic = ImageCacher.getInstance();
        return ic.getImage("template.gif");
    }

    /*
     * Unable to fully structure code
     */
    protected String extractPrefix(ITextViewer viewer, int offset) {
        i = offset;
        document = viewer.getDocument();
        if (i <= document.getLength()) ** GOTO lbl7
        return "";
        {
            while ((ch = document.getChar(i - 1)) == '<' || Character.isJavaIdentifierPart(ch)) {
                --i;
lbl7:
                // 2 sources

                if (i > 0) continue;
            }
            return document.get(i, offset - i);
        }
    }

    protected int getRelevance(Template template, String prefix) {
        if (template.getName().startsWith(prefix)) {
            return 200;
        }
        return 0;
    }

    protected ICompletionProposal createProposal(Template template, TemplateContext context, IRegion region, int relevance) {
        return new SQLTemplateProposal(template, context, region, this.getImage(template), relevance);
    }

    private static final class ProposalComparator
    implements Comparator {
        private ProposalComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((TemplateProposal)o2).getRelevance() - ((TemplateProposal)o1).getRelevance();
        }
    }

    class SQLParseThread
    implements Runnable {
        IDocument doc;
        int offset;
        String demiliter;
        boolean _isComplete = false;

        public SQLParseThread(IDocument doc, int offset, String demiliter) {
            this.doc = doc;
            this.offset = offset;
            this.demiliter = demiliter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (SQLContentAssistantProcessor2.this.isSQLParsing) {
                return;
            }
            Object object = SQLContentAssistantProcessor2.this.lock;
            synchronized (object) {
                try {
                    SQLContentAssistantProcessor2.this.isSQLParsing = true;
                    CurrentSql cs = new CurrentSql(this.doc, this.offset, this.demiliter);
                    String allSql = cs.getSql();
                    if (allSql != null && !"".equals(allSql.trim())) {
                        TimeWatcher tw = new TimeWatcher();
                        tw.start();
                        SqlParser parser = new SqlParser(allSql, DbPlugin.getSqlFormatRult());
                        ASTVisitor2 visitor = new ASTVisitor2();
                        ASTRoot node = new ASTRoot();
                        parser.parse((INode)node);
                        node.accept((IVisitor)visitor, null);
                        SQLContentAssistantProcessor2.this.currentNode = SQLContentAssistantProcessor2.this.findCurrentNode(visitor, cs.getOffsetSql());
                        if (SQLContentAssistantProcessor2.this.currentNode == null) {
                            StringBuffer sb = new StringBuffer();
                            sb.append("\u30aa\u30d5\u30bb\u30c3\u30c8\u306b\u5bfe\u3059\u308b\u30ce\u30fc\u30c9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093").append(DbPluginConstant.LINE_SEP);
                            sb.append("\u5168SQL\u306f").append(DbPluginConstant.LINE_SEP);
                            sb.append(allSql).append(DbPluginConstant.LINE_SEP);
                            sb.append("\u30aa\u30d5\u30bb\u30c3\u30c8\u307e\u3067\u306eSQL\u306f").append(DbPluginConstant.LINE_SEP);
                            sb.append(cs.getOffsetSql()).append(DbPluginConstant.LINE_SEP);
                            DbPlugin.log(sb.toString());
                        }
                        tw.stop();
                    }
                }
                finally {
                    this._isComplete = true;
                    SQLContentAssistantProcessor2.this.isSQLParsing = false;
                }
            }
        }

        public boolean isComplete() {
            return this._isComplete;
        }
    }

    class SQLParserTimeout
    extends ParserException {
        private static final long serialVersionUID = 1L;

        public SQLParserTimeout(String message) {
            super(message, null, 0, 0);
        }
    }
}

