/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.dialogs;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import zigen.plugin.db.core.SchemaInfo;
import zigen.plugin.db.ui.dialogs.IDBDialogSettings;

public class DBDialogSettings
implements IDBDialogSettings {
    private String name;
    private Map sections;
    private Map items;
    private Map arrayItems;
    private Map schemaInfoItems;
    private final String TAG_SECTION = "section";
    private final String TAG_NAME = "name";
    private final String TAG_KEY = "key";
    private final String TAG_VALUE = "value";
    private final String TAG_LIST = "list";
    private final String TAG_ITEM = "item";
    private final String TAG_SCHEMA_LIST = "schemas";
    private final String TAG_SCHEMA = "schema";
    private final String TAG_CHECKED = "checked";

    public DBDialogSettings(String sectionName) {
        this.name = sectionName;
        this.items = new HashMap();
        this.arrayItems = new HashMap();
        this.sections = new HashMap();
        this.schemaInfoItems = new HashMap();
    }

    public IDBDialogSettings addNewSection(String sectionName) {
        DBDialogSettings section = new DBDialogSettings(sectionName);
        this.addSection(section);
        return section;
    }

    public void addSection(IDialogSettings section) {
        this.sections.put(section.getName(), section);
    }

    public String get(String key) {
        return (String)this.items.get(key);
    }

    public String[] getArray(String key) {
        return (String[])this.arrayItems.get(key);
    }

    public SchemaInfo[] getSchemaInfos(String key) {
        return (SchemaInfo[])this.schemaInfoItems.get(key);
    }

    public boolean getBoolean(String key) {
        return new Boolean((String)this.items.get(key));
    }

    public double getDouble(String key) throws NumberFormatException {
        String setting = (String)this.items.get(key);
        if (setting == null) {
            throw new NumberFormatException("There is no setting associated with the key \"" + key + "\"");
        }
        return new Double(setting);
    }

    public float getFloat(String key) throws NumberFormatException {
        String setting = (String)this.items.get(key);
        if (setting == null) {
            throw new NumberFormatException("There is no setting associated with the key \"" + key + "\"");
        }
        return new Float(setting).floatValue();
    }

    public int getInt(String key) throws NumberFormatException {
        String setting = (String)this.items.get(key);
        if (setting == null) {
            throw new NumberFormatException("There is no setting associated with the key \"" + key + "\"");
        }
        return new Integer(setting);
    }

    public long getLong(String key) throws NumberFormatException {
        String setting = (String)this.items.get(key);
        if (setting == null) {
            throw new NumberFormatException("There is no setting associated with the key \"" + key + "\"");
        }
        return new Long(setting);
    }

    public String getName() {
        return this.name;
    }

    public IDBDialogSettings getSection(String sectionName) {
        return (IDBDialogSettings)this.sections.get(sectionName);
    }

    public IDBDialogSettings[] getSections() {
        Collection values = this.sections.values();
        IDBDialogSettings[] result = new IDBDialogSettings[values.size()];
        values.toArray(result);
        return result;
    }

    public void load(Reader r) {
        Document document = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = parser.parse(new InputSource(r));
            Node root = document.getFirstChild();
            while (root.getNodeType() == 8) {
                document.removeChild(root);
                root = document.getFirstChild();
            }
            this.load(document, (Element)root);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {}
    }

    public void load(String fileName) throws IOException {
        FileInputStream stream = new FileInputStream(fileName);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, "utf-8"));
        this.load(reader);
        reader.close();
    }

    private void load(Document document, Element root) {
        Object[] value;
        Element node;
        ArrayList<Object> valueList;
        NodeList list;
        String key;
        Element child;
        Node n;
        this.name = root.getAttribute("name");
        NodeList l = root.getElementsByTagName("item");
        int i = 0;
        while (i < l.getLength()) {
            n = l.item(i);
            if (root == n.getParentNode()) {
                String key2 = ((Element)l.item(i)).getAttribute("key");
                String value2 = ((Element)l.item(i)).getAttribute("value");
                this.items.put(key2, value2);
            }
            ++i;
        }
        l = root.getElementsByTagName("list");
        i = 0;
        while (i < l.getLength()) {
            n = l.item(i);
            if (root == n.getParentNode()) {
                child = (Element)l.item(i);
                key = child.getAttribute("key");
                list = child.getElementsByTagName("item");
                valueList = new ArrayList<Object>();
                int j = 0;
                while (j < list.getLength()) {
                    node = (Element)list.item(j);
                    if (child == node.getParentNode()) {
                        valueList.add(node.getAttribute("value"));
                    }
                    ++j;
                }
                value = new String[valueList.size()];
                valueList.toArray(value);
                this.arrayItems.put(key, value);
            }
            ++i;
        }
        l = root.getElementsByTagName("schemas");
        i = 0;
        while (i < l.getLength()) {
            n = l.item(i);
            if (root == n.getParentNode()) {
                child = (Element)l.item(i);
                key = child.getAttribute("key");
                list = child.getElementsByTagName("schema");
                valueList = new ArrayList();
                int j = 0;
                while (j < list.getLength()) {
                    node = (Element)list.item(j);
                    if (child == node.getParentNode()) {
                        SchemaInfo s = new SchemaInfo();
                        s.setName(node.getAttribute("name"));
                        s.setChecked(new Boolean(node.getAttribute("checked")));
                        valueList.add(s);
                    }
                    ++j;
                }
                value = new SchemaInfo[valueList.size()];
                valueList.toArray(value);
                this.schemaInfoItems.put(key, value);
            }
            ++i;
        }
        l = root.getElementsByTagName("section");
        i = 0;
        while (i < l.getLength()) {
            n = l.item(i);
            if (root == n.getParentNode()) {
                DBDialogSettings s = new DBDialogSettings("NoName");
                s.load(document, (Element)n);
                this.addSection(s);
            }
            ++i;
        }
    }

    public void put(String key, String[] value) {
        this.arrayItems.put(key, value);
    }

    public void put(String key, SchemaInfo[] value) {
        this.schemaInfoItems.put(key, value);
    }

    public void put(String key, double value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, float value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, int value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, long value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, String value) {
        this.items.put(key, value);
    }

    public void put(String key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    public void save(Writer writer) throws IOException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.save(document, document);
            StreamResult result = new StreamResult(writer);
            DOMSource source = new DOMSource(document);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (TransformerException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public void save(String fileName) throws IOException {
        FileOutputStream stream = new FileOutputStream(fileName);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "utf-8");
        this.save(writer);
        writer.close();
    }

    private void save(Document document, Node parent) {
        Element c;
        int index;
        Object[] value;
        Element child;
        Element root = document.createElement("section");
        parent.appendChild(root);
        root.setAttribute("name", this.name == null ? "" : this.name);
        for (String key : this.items.keySet()) {
            child = document.createElement("item");
            root.appendChild(child);
            child.setAttribute("key", key == null ? "" : key);
            String string = (String)this.items.get(key);
            child.setAttribute("value", string == null ? "" : string);
        }
        for (String key : this.arrayItems.keySet()) {
            child = document.createElement("list");
            root.appendChild(child);
            child.setAttribute("key", key == null ? "" : key);
            value = (String[])this.arrayItems.get(key);
            if (value == null) continue;
            index = 0;
            while (index < value.length) {
                c = document.createElement("item");
                child.appendChild(c);
                Object string = value[index];
                c.setAttribute("value", (String)(string == null ? "" : string));
                ++index;
            }
        }
        for (String key : this.schemaInfoItems.keySet()) {
            child = document.createElement("schemas");
            root.appendChild(child);
            child.setAttribute("key", key == null ? "" : key);
            value = (SchemaInfo[])this.schemaInfoItems.get(key);
            if (value == null) continue;
            index = 0;
            while (index < value.length) {
                c = document.createElement("schema");
                child.appendChild(c);
                Object schema = value[index];
                c.setAttribute("name", ((SchemaInfo)schema).getName());
                c.setAttribute("checked", String.valueOf(((SchemaInfo)schema).isChecked()));
                ++index;
            }
        }
        Iterator<Object> i = this.sections.values().iterator();
        while (i.hasNext()) {
            ((DBDialogSettings)i.next()).save(document, root);
        }
    }

    public void addSection(IDBDialogSettings section) {
        this.sections.put(section.getName(), section);
    }

    public void removeSection(String sectionName) {
        this.sections.remove(sectionName);
    }

    public boolean hasSection(String sectionName) {
        return this.sections.containsKey(sectionName);
    }
}

