/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import java.sql.Connection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.core.TableSearcher;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleSourceTypeSearcher;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.OracleSequence;
import zigen.plugin.db.ui.internal.OracleSource;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.View;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.Messages;
import zigen.plugin.db.ui.jobs.RefreshTreeNodeAction;
import zigen.plugin.db.ui.views.TableSearchThread;

public class TableTypeSearchJob
extends AbstractJob {
    public static final String VisibleFolderPattern = "^TABLE|^SYNONYM|^ALIAS";
    private TreeViewer viewer;
    private Schema schema;

    public TableTypeSearchJob(TreeViewer viewer, Schema schema) {
        super(Messages.getString("TableTypeSearchJob.1"));
        this.viewer = viewer;
        this.schema = schema;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            Connection con = Transaction.getInstance(this.schema.getDbConfig()).getConnection();
            this.schema.removeChildAll();
            this.showResults(new RefreshTreeNodeAction(this.viewer, this.schema));
            String[] tableTypes = this.schema.getDataBase().getTableType();
            monitor.beginTask(Messages.getString("TableTypeSearchJob.2"), tableTypes.length);
            int i = 0;
            while (i < tableTypes.length) {
                Folder folder;
                String[] types = new String[]{tableTypes[i]};
                monitor.subTask(String.valueOf(tableTypes[i]) + Messages.getString("TableTypeSearchJob.3"));
                if (tableTypes[i].toUpperCase().matches(VisibleFolderPattern)) {
                    TableInfo[] tables = TableSearcher.execute(con, this.schema.getName(), types);
                    TableSearchThread.addFolderAndTables(con, this.schema, tableTypes[i], tables);
                } else if ("VIEW".equals(tableTypes[i].toUpperCase())) {
                    folder = new Folder();
                    folder.setName(tableTypes[i]);
                    View view = new View();
                    view.setName(DbPluginConstant.TREE_LEAF_LOADING);
                    folder.addChild(view);
                    this.schema.addChild(folder);
                } else if ("SEQUENCE".equals(tableTypes[i])) {
                    switch (DBType.getType(this.schema.getDbConfig())) {
                        case 1: {
                            folder = new Folder();
                            folder.setName(tableTypes[i]);
                            OracleSequence seq = new OracleSequence();
                            seq.setName(DbPluginConstant.TREE_LEAF_LOADING);
                            folder.addChild(seq);
                            this.schema.addChild(folder);
                        }
                    }
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(1);
                ++i;
            }
            IDBConfig conifg = this.schema.getDbConfig();
            switch (DBType.getType(conifg)) {
                case 1: {
                    String owner = this.schema.getName();
                    monitor.subTask("SELECT DISTINCT TYPE FROM ALL_SOURCE...");
                    String[] sourceTypes = OracleSourceTypeSearcher.execute(con, owner);
                    this.schema.setSourceType(sourceTypes);
                    int i2 = 0;
                    while (i2 < sourceTypes.length) {
                        monitor.subTask(String.valueOf(sourceTypes[i2]) + Messages.getString("TableTypeSearchJob.3"));
                        String stype = sourceTypes[i2];
                        Folder folder = new Folder(stype);
                        OracleSource source = new OracleSource();
                        source.setName(DbPluginConstant.TREE_LEAF_LOADING);
                        folder.addChild(source);
                        this.schema.addChild(folder);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        ++i2;
                    }
                    break;
                }
            }
            this.schema.setExpanded(true);
            this.showResults(new RefreshTreeNodeAction(this.viewer, this.schema, 1));
        }
        catch (Exception e) {
            this.schema.setExpanded(false);
            this.showErrorMessage(Messages.getString("TableTypeSearchJob.5"), e);
        }
        return Status.OK_STATUS;
    }
}

