/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.part.ViewPart;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.IStatusChangeListener;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.PluginSettingsManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SchemaInfo;
import zigen.plugin.db.ui.actions.AutoDelayListener;
import zigen.plugin.db.ui.bookmark.DragBookmarkAdapter;
import zigen.plugin.db.ui.bookmark.DropBookmarkAdapter;
import zigen.plugin.db.ui.bookmark.TreeLeafListTransfer;
import zigen.plugin.db.ui.views.TreeContentProvider;
import zigen.plugin.db.ui.views.TreeDoubleClickHandler;
import zigen.plugin.db.ui.views.TreeLabelProvider;
import zigen.plugin.db.ui.views.TreeViewListener;
import zigen.plugin.db.ui.views.TreeViewSchemaFilter;
import zigen.plugin.db.ui.views.TreeViewSorter;
import zigen.plugin.db.ui.views.internal.ColumnFilter;
import zigen.plugin.db.ui.views.internal.TableFilter;

public abstract class AbstractTreeView
extends ViewPart
implements IStatusChangeListener {
    protected PluginSettingsManager settringMgr = DbPlugin.getDefault().getPluginSettingsManager();
    protected int maxSize = 20;
    protected TreeViewer viewer;
    Label tableFilterLabel;
    Label columnFilterLabel;
    protected Combo tableFilterComb;
    protected Combo columnFilterComb;
    protected Button searchBtn;
    protected List tableFilterHistory;
    protected List columnFilterHistory;
    protected boolean isAutoSearchMode = false;
    protected TreeContentProvider contentProvider;
    protected ImageCacher ic = ImageCacher.getInstance();
    protected Composite tool;
    boolean onColumnFilter = false;
    TableFilter fTableFilter;
    ColumnFilter fColumnFilter;
    Map filterMap = new TreeMap();
    protected IDBConfig currentIDBConfig;

    public void setLinkingEnabled(boolean enabled) {
        this.settringMgr.setValue("KEY_LINKED_EDITOR", new Boolean(enabled));
    }

    public boolean isLinkingEnabled() {
        Boolean b = (Boolean)this.settringMgr.getValue("KEY_LINKED_EDITOR");
        return b == null ? false : b;
    }

    public void createPartControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        main.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 2;
        main.setLayout((Layout)gridLayout);
        this.createFilterBar(main);
        this.createTreeArea(main);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        DbPlugin.addStatusChangeListener(this);
    }

    protected void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractTreeView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener((IDoubleClickListener)new TreeDoubleClickHandler());
    }

    protected void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    abstract void makeActions();

    abstract void fillContextMenu(IMenuManager var1);

    abstract void fillLocalPullDown(IMenuManager var1);

    abstract void fillLocalToolBar(IToolBarManager var1);

    abstract void setGlobalAction(IStructuredSelection var1);

    abstract void selectionChangeHandler(SelectionChangedEvent var1);

    protected void createTreeArea(Composite parent) {
        Composite body = new Composite(parent, 0);
        body.setLayoutData((Object)new GridData(1808));
        body.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(body, 770);
        int dragOption = 19;
        Transfer[] transfers = new Transfer[]{TreeLeafListTransfer.getInstance()};
        this.viewer.addDragSupport(dragOption, transfers, (DragSourceListener)new DragBookmarkAdapter(this.viewer));
        this.viewer.addDropSupport(dragOption, transfers, (DropTargetListener)new DropBookmarkAdapter(this.viewer));
        this.contentProvider = new TreeContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.viewer.setSorter((ViewerSorter)new TreeViewSorter());
        this.viewer.setUseHashlookup(true);
        this.viewer.setInput((Object)this.getViewSite());
        this.viewer.expandToLevel(2);
        this.viewer.addTreeListener((ITreeViewerListener)new TreeViewListener());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractTreeView.this.selectionChangeHandler(event);
            }
        });
    }

    protected void createFilterBar(final Composite parent) {
        this.tool = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        this.tool.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 2;
        gridLayout.horizontalSpacing = 1;
        gridLayout.verticalSpacing = 1;
        this.tool.setLayout((Layout)gridLayout);
        this.tool.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                parent.getParent().layout(true);
                parent.layout(true);
            }
        });
        this.addTableFilter(this.tool);
        this.addColumnFilter(this.tool);
    }

    protected void addColumnFilter(Composite tool) {
        this.columnFilterLabel = new Label(tool, 0);
        GridData gridData = new GridData(4);
        this.columnFilterLabel.setLayoutData((Object)gridData);
        this.columnFilterLabel.setText("Column:");
        this.columnFilterComb = new Combo(tool, 0);
        this.columnFilterComb.setVisibleItemCount(20);
        this.columnFilterComb.setLayoutData((Object)new GridData(768));
        this.columnFilterComb.setText("");
        if (!this.isAutoSearchMode) {
            this.columnFilterComb.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.character == '\r') {
                        e.doit = false;
                        AbstractTreeView.this.columnFilter(AbstractTreeView.this.columnFilterComb.getText());
                    }
                }
            });
        } else {
            this.columnFilterComb.addKeyListener((KeyListener)new AutoDelayFiltertListener(2));
        }
        this.columnFilterHistory = this.loadColumnFilterHistory();
        if (this.columnFilterHistory != null) {
            if (this.columnFilterHistory.size() == 0) {
                this.columnFilterComb.add("");
            } else {
                int i = 0;
                while (i < this.columnFilterHistory.size()) {
                    this.columnFilterComb.add((String)this.columnFilterHistory.get(i));
                    ++i;
                }
            }
        }
    }

    protected void addTableFilter(Composite tool) {
        this.tableFilterLabel = new Label(tool, 0);
        GridData gridData = new GridData(4);
        this.tableFilterLabel.setLayoutData((Object)gridData);
        this.tableFilterLabel.setText("Filter:");
        this.tableFilterComb = new Combo(tool, 0);
        this.tableFilterComb.setVisibleItemCount(20);
        this.tableFilterComb.setLayoutData((Object)new GridData(768));
        this.tableFilterComb.setText("");
        if (!this.isAutoSearchMode) {
            this.tableFilterComb.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.character == '\r') {
                        e.doit = false;
                        AbstractTreeView.this.tableFilter(AbstractTreeView.this.tableFilterComb.getText());
                    }
                }
            });
        } else {
            this.tableFilterComb.addKeyListener((KeyListener)new AutoDelayFiltertListener(1));
        }
        this.tableFilterHistory = this.loadFilterHistory();
        if (this.tableFilterHistory != null) {
            if (this.tableFilterHistory.size() == 0) {
                this.tableFilterComb.add("");
            } else {
                int i = 0;
                while (i < this.tableFilterHistory.size()) {
                    this.tableFilterComb.add((String)this.tableFilterHistory.get(i));
                    ++i;
                }
            }
        }
    }

    protected void tableFilter(String condition) {
        if (this.fTableFilter != null) {
            this.viewer.removeFilter((ViewerFilter)this.fTableFilter);
        }
        this.fTableFilter = new TableFilter(condition);
        this.viewer.addFilter((ViewerFilter)this.fTableFilter);
        if (this.tableFilterHistory.contains(condition)) {
            this.tableFilterHistory.remove(condition);
            this.tableFilterComb.remove(condition);
        }
        this.tableFilterHistory.add(0, condition);
        this.tableFilterComb.add(condition, 0);
        this.tableFilterComb.select(0);
        this.removeOverHistory(this.tableFilterHistory, this.tableFilterComb);
    }

    protected void columnFilter(String condition) {
        if (this.fColumnFilter != null) {
            this.viewer.removeFilter((ViewerFilter)this.fColumnFilter);
        }
        this.fColumnFilter = new ColumnFilter(condition);
        this.viewer.addFilter((ViewerFilter)this.fColumnFilter);
        if (this.columnFilterHistory.contains(condition)) {
            this.columnFilterHistory.remove(condition);
            this.columnFilterComb.remove(condition);
        }
        this.columnFilterHistory.add(0, condition);
        this.columnFilterComb.add(condition, 0);
        this.columnFilterComb.select(0);
        this.removeOverHistory(this.columnFilterHistory, this.columnFilterComb);
    }

    public void setSchemaFilter(IDBConfig config, SchemaInfo[] scehmaInfos) {
        try {
            TreeViewSchemaFilter filter = null;
            if (this.filterMap.containsKey(config.getDbName())) {
                filter = (TreeViewSchemaFilter)((Object)this.filterMap.get(config.getDbName()));
                this.viewer.removeFilter((ViewerFilter)filter);
            }
            filter = new TreeViewSchemaFilter(scehmaInfos);
            this.filterMap.put(config.getDbName(), filter);
            this.viewer.addFilter((ViewerFilter)filter);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public void removeSchemaFilter(IDBConfig config, SchemaInfo[] scehmaInfos) {
        try {
            TreeViewSchemaFilter filter = null;
            if (this.filterMap.containsKey(config.getDbName())) {
                filter = (TreeViewSchemaFilter)((Object)this.filterMap.get(config.getDbName()));
                this.viewer.removeFilter((ViewerFilter)filter);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private void removeOverHistory(List filterHistory, Combo filterComb) {
        while (filterHistory.size() > this.maxSize) {
            int i = filterHistory.size() - 1;
            filterHistory.remove(i);
            filterComb.remove(i);
        }
    }

    public void dispose() {
        DbPlugin.removeStatusChangeListener(this);
        this.saveFilterHistory();
    }

    private void saveFilterHistory() {
        this.settringMgr.setValue("KEY_FILTER_LIST", this.tableFilterHistory);
        this.settringMgr.setValue("KEY_FILTER_LIST_COLUMN", this.columnFilterHistory);
    }

    private List loadFilterHistory() {
        List list = (List)this.settringMgr.getValue("KEY_FILTER_LIST");
        if (list != null) {
            return list;
        }
        return new ArrayList();
    }

    private List loadColumnFilterHistory() {
        List list = (List)this.settringMgr.getValue("KEY_FILTER_LIST_COLUMN");
        if (list != null) {
            return list;
        }
        return new ArrayList();
    }

    public TreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public void setStatusMessage(IDBConfig currentIDBConfig, String message) {
        this.currentIDBConfig = currentIDBConfig;
        this.getIStatusLineManager().setMessage(message);
    }

    public void setStatusErrorMessage(IDBConfig currentIDBConfig, String message) {
        this.currentIDBConfig = currentIDBConfig;
        this.getIStatusLineManager().setErrorMessage(message);
    }

    protected IStatusLineManager getIStatusLineManager() {
        IViewSite vieweSite = super.getViewSite();
        IActionBars actionBars = vieweSite.getActionBars();
        return actionBars.getStatusLineManager();
    }

    class AutoDelayFiltertListener
    extends AutoDelayListener {
        private static final int delayTime = 300;
        int mode;

        public AutoDelayFiltertListener(int mode) {
            super(300);
            this.mode = 1;
            this.mode = mode;
        }

        public Runnable createExecutAction() {
            return new Runnable(){

                public void run() {
                    try {
                        if (AutoDelayFiltertListener.this.mode == 1) {
                            String condition = ((AutoDelayFiltertListener)AutoDelayFiltertListener.this).AbstractTreeView.this.tableFilterComb.getText();
                            AbstractTreeView.this.tableFilter(condition);
                        } else {
                            String condition = ((AutoDelayFiltertListener)AutoDelayFiltertListener.this).AbstractTreeView.this.columnFilterComb.getText();
                            AbstractTreeView.this.columnFilter(condition);
                        }
                    }
                    catch (Exception e) {
                        DbPlugin.log(e);
                    }
                }
            };
        }
    }
}

