/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.CursorLinePainter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.MatchingCharacterPainter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.ITextEditorExtension2;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.IStatusChangeListener;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SQLHistoryManager;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.ExplainForQueryAction;
import zigen.plugin.db.ui.actions.GlobalAction;
import zigen.plugin.db.ui.actions.LockDataBaseAction;
import zigen.plugin.db.ui.actions.OpenViewAction;
import zigen.plugin.db.ui.actions.ShowHistoryViewAction;
import zigen.plugin.db.ui.bookmark.TreeLeafListTransfer;
import zigen.plugin.db.ui.internal.TreeNode;
import zigen.plugin.db.ui.util.LineNumberRulerColumnUtil;
import zigen.plugin.db.ui.util.ProjectUtil;
import zigen.plugin.db.ui.util.ResourceUtil;
import zigen.plugin.db.ui.util.StyledTextUtil;
import zigen.plugin.db.ui.views.CommitModeAction;
import zigen.plugin.db.ui.views.DropTreeLeafAdapter;
import zigen.plugin.db.ui.views.HistoryView;
import zigen.plugin.db.ui.views.Messages;
import zigen.plugin.db.ui.views.StatusLineContributionItem;
import zigen.plugin.db.ui.views.internal.ColorManager;
import zigen.plugin.db.ui.views.internal.SQLCharacterPairMatcher;
import zigen.plugin.db.ui.views.internal.SQLCodeConfiguration;
import zigen.plugin.db.ui.views.internal.SQLDocument;
import zigen.plugin.db.ui.views.internal.SQLOutinePage;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;
import zigen.plugin.db.ui.views.internal.SQLToolBar;

public class SQLExecuteView
extends ViewPart
implements ITextEditorExtension2,
IPropertyChangeListener,
ISelectionListener,
IStatusChangeListener {
    public static final String AUTO_COMMIT = Messages.getString("AbstractSQLExecuteView.0");
    public static final String MANUAL_COMMIT = Messages.getString("AbstractSQLExecuteView.1");
    protected StatusLineContributionItem commitModeItem;
    protected StatusLineContributionItem positionItem;
    protected IDBConfig[] configs;
    protected SQLHistoryManager historyManager = DbPlugin.getDefault().getHistoryManager();
    protected Transaction trans;
    protected SQLSourceViewer sqlViewer;
    protected LineNumberRulerColumn rulerCol;
    protected SQLCodeConfiguration sqlConfiguration;
    protected ColorManager colorManager = new ColorManager();
    protected ImageCacher ic = ImageCacher.getInstance();
    protected MatchingCharacterPainter painter;
    protected CursorLinePainter cpainter;
    protected ExplainForQueryAction explainForQueryAction;
    protected ShowHistoryViewAction showHistoryViewAction = new ShowHistoryViewAction();
    IAction currExecAction;
    IAction selectExecAction;
    OpenViewAction openViewAction;
    IAction changeSQLDemiliterAction;
    Composite sqlComposite;
    Composite footerComposite;
    SQLToolBar toolBar;
    ResourceMarkerAnnotationModel annotationModel;
    protected Color fFindScopeHighlightColor;
    protected Map fGlobalActions = new HashMap();
    protected List fSelectionActions = new ArrayList();
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            SQLExecuteView.this.updateSelectionDependentActions();
        }
    };
    private ITextListener textListener = new ITextListener(){

        public void textChanged(TextEvent event) {
            IUpdate findReplace = (IUpdate)SQLExecuteView.this.fGlobalActions.get(ActionFactory.FIND.getId());
            if (findReplace != null) {
                findReplace.update();
            }
        }
    };
    private List extensionList = new ArrayList();
    SQLOutinePage outlinePage;

    public void setSqlText(String sql) {
        if (this.sqlViewer != null) {
            this.sqlViewer.getDocument().set(sql);
        }
    }

    public IDBConfig getConfig() {
        return this.toolBar.getConfig();
    }

    public SourceViewer getSqlViewer() {
        return this.sqlViewer;
    }

    public SQLHistoryManager getSQLHistoryManager() {
        return this.historyManager;
    }

    public void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SQLExecuteView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.sqlViewer.getTextWidget());
        this.sqlViewer.getTextWidget().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.sqlViewer);
        this.toolBar.updateHistoryButton();
        this.contributeToActionBars();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.openViewAction);
        manager.add((IAction)new LockDataBaseAction(this.sqlViewer));
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.showHistoryViewAction);
        manager.add((IAction)this.openViewAction);
    }

    void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)new GlobalAction((TextViewer)this.sqlViewer, 1));
        manager.add((IAction)new GlobalAction((TextViewer)this.sqlViewer, 2));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new GlobalAction((TextViewer)this.sqlViewer, 3));
        manager.add((IAction)new GlobalAction((TextViewer)this.sqlViewer, 4));
        manager.add((IAction)new GlobalAction((TextViewer)this.sqlViewer, 5));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new GlobalAction((TextViewer)this.sqlViewer, 6));
        manager.add((IAction)new GlobalAction((TextViewer)this.sqlViewer, 1008));
        manager.add((IAction)new GlobalAction((TextViewer)this.sqlViewer, 1012));
        manager.add((IAction)new GlobalAction((TextViewer)this.sqlViewer, 7));
        manager.add((IContributionItem)new Separator("FIND"));
        manager.add((IAction)this.fGlobalActions.get(ActionFactory.FIND.getId()));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new GlobalAction((TextViewer)this.sqlViewer, 1003));
        manager.add((IAction)new GlobalAction((TextViewer)this.sqlViewer, 1004));
        manager.add((IAction)new GlobalAction((TextViewer)this.sqlViewer, 1005));
        manager.add((IAction)new GlobalAction((TextViewer)this.sqlViewer, 1013));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new GlobalAction((TextViewer)this.sqlViewer, 1007));
        manager.add((IAction)new GlobalAction((TextViewer)this.sqlViewer, 1006));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new GlobalAction((TextViewer)this.sqlViewer, 1010));
        manager.add((IAction)new GlobalAction((TextViewer)this.sqlViewer, 1011));
        manager.add((IAction)new GlobalAction((TextViewer)this.sqlViewer, 1001));
        manager.add((IAction)new GlobalAction((TextViewer)this.sqlViewer, 1002));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.explainForQueryAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new GlobalAction((TextViewer)this.sqlViewer, 1009));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator());
    }

    public void createPartControl(Composite parent) {
        Composite header = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        header.setLayout((Layout)layout);
        this.toolBar = new SQLToolBar();
        this.toolBar.createPartControl(header);
        this.createSQLInputPart(header);
        this.makeActions();
        this.createContextMenu();
        this.contributeToStatusLine();
        this.initializeFindScopeColor((ISourceViewer)this.sqlViewer);
        DbPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        DbPlugin.addStatusChangeListener(this);
        this.setExtensionPoint();
    }

    protected void createSQLInputPart(Composite header) {
        this.sqlComposite = new Composite(header, 0);
        this.sqlComposite.setLayout((Layout)new FillLayout());
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.toolBar.getCoolBar(), 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.sqlComposite.setLayoutData((Object)data);
        CompositeRuler ruler = new CompositeRuler();
        this.rulerCol = new LineNumberRulerColumn();
        LineNumberRulerColumnUtil.changeColor(this.colorManager, this.rulerCol);
        ruler.addDecorator(0, (IVerticalRulerColumn)this.rulerCol);
        this.sqlViewer = new SQLSourceViewer(this.sqlComposite, (IVerticalRuler)ruler, null, false, 2818);
        this.sqlViewer.setSecondaryId(this.getViewSite().getSecondaryId());
        this.sqlViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SQLExecuteView.this.selectionChangeHandler(event);
            }
        });
        this.initializeViewerFont((ISourceViewer)this.sqlViewer);
        DropTarget target = new DropTarget((Control)this.sqlViewer.getTextWidget(), 23);
        Transfer[] types = new Transfer[]{TreeLeafListTransfer.getInstance(), TextTransfer.getInstance(), FileTransfer.getInstance()};
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new DropTreeLeafAdapter((SourceViewer)this.sqlViewer));
        this.sqlConfiguration = new SQLCodeConfiguration(this.colorManager);
        this.sqlViewer.configure(this.sqlConfiguration);
        this.sqlViewer.setDocument((IDocument)new SQLDocument());
        SQLSourceViewer extension = this.sqlViewer;
        this.painter = new MatchingCharacterPainter((ISourceViewer)this.sqlViewer, (ICharacterPairMatcher)new SQLCharacterPairMatcher());
        this.painter.setColor(this.colorManager.getColor("SQLEditorPreferencePage.ColorMatching"));
        extension.addPainter((IPainter)this.painter);
        this.cpainter = new CursorLinePainter((ITextViewer)this.sqlViewer);
        this.cpainter.setHighlightColor(this.colorManager.getColor("SQLEditorPreferencePage.CursorLine"));
        this.sqlViewer.addPainter((IPainter)this.cpainter);
        this.getSite().setSelectionProvider((ISelectionProvider)this.sqlViewer);
        this.getViewSite().getPage().addSelectionListener((ISelectionListener)this);
        StyledTextUtil.changeColor(this.colorManager, this.sqlViewer.getTextWidget());
        this.setGlobalAction();
        this.sqlViewer.getSelectionProvider().addSelectionChangedListener(this.selectionChangedListener);
        this.sqlViewer.addTextListener(this.textListener);
        this.sqlViewer.getTextWidget().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent arg0) {
                SQLExecuteView.this.updatePosition();
            }
        });
        this.sqlViewer.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent arg0) {
                try {
                    SQLExecuteView.this.updatePosition();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.sqlViewer.setDbConfig(this.toolBar.getConfig());
        this.toolBar.setSQLSourceViewer(this.sqlViewer);
    }

    protected void initializeViewerFont(ISourceViewer viewer) {
        StyledText styledText = viewer.getTextWidget();
        styledText.setFont(DbPlugin.getDefaultFont());
    }

    public final void updateCombo(IDBConfig newConfig) {
        this.toolBar.updateCombo(newConfig);
    }

    void changeTitleImageAndCommitModeText(IDBConfig config) {
        try {
            if (config != null && this.toolBar != null && this.toolBar.getConfig() != null && config.getDbName().equals(this.toolBar.getConfig().getDbName())) {
                this.trans = Transaction.getInstance(config);
                this.ic = ImageCacher.getInstance();
                if (this.trans.isConneting()) {
                    super.setTitleImage(this.ic.getImage("connecteddb.gif"));
                } else {
                    super.setTitleImage(this.ic.getImage("db.gif"));
                }
                if (config.isAutoCommit()) {
                    this.commitModeItem.setText(AUTO_COMMIT);
                } else {
                    this.commitModeItem.setText(MANUAL_COMMIT);
                }
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    public void dispose() {
        this.colorManager.dispose();
        this.getViewSite().getPage().removeSelectionListener((ISelectionListener)this);
        DbPlugin.removeStatusChangeListener(this);
        for (ISelectionListener listener : this.extensionList) {
            this.getViewSite().getPage().removeSelectionListener(listener);
        }
        this.fSelectionActions.clear();
        this.fGlobalActions.clear();
        this.sqlViewer.getSelectionProvider().removeSelectionChangedListener(this.selectionChangedListener);
        this.sqlViewer.removeTextListener(this.textListener);
        this.sqlViewer = null;
        super.dispose();
    }

    protected IStatusLineManager getIStatusLineManager() {
        IViewSite vieweSite = super.getViewSite();
        IActionBars actionBars = vieweSite.getActionBars();
        return actionBars.getStatusLineManager();
    }

    public void updatePosition() {
        StringBuffer sb = new StringBuffer();
        try {
            IDocument doc = this.getSqlViewer().getDocument();
            StyledText text = this.getSqlViewer().getTextWidget();
            int offset = text.getCaretOffset();
            int line = doc.getLineOfOffset(offset);
            sb.append(doc.getLineOfOffset(offset) + 1);
            sb.append(" : ");
            sb.append(offset - doc.getLineOffset(line) + 1);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.positionItem.setText(sb.toString());
    }

    public void contributeToStatusLine() {
        IStatusLineManager manager = this.getIStatusLineManager();
        this.commitModeItem = new StatusLineContributionItem("CommitMode");
        this.commitModeItem.setText(MANUAL_COMMIT);
        manager.add((IContributionItem)this.commitModeItem);
        this.positionItem = new StatusLineContributionItem("Position");
        this.positionItem.setText("");
        manager.add((IContributionItem)this.positionItem);
    }

    public void setStatusMessage(String message) {
        this.getIStatusLineManager().setMessage(message);
    }

    public void setStatusErrorMessage(String message) {
        this.getIStatusLineManager().setErrorMessage(message);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.sqlConfiguration != null && this.sqlViewer != null) {
            StyledTextUtil.changeColor(this.colorManager, this.sqlViewer.getTextWidget());
            LineNumberRulerColumnUtil.changeColor(this.colorManager, this.rulerCol);
            this.sqlConfiguration.updatePreferences(this.sqlViewer.getDocument());
            this.painter.setColor(this.colorManager.getColor("SQLEditorPreferencePage.ColorMatching"));
            this.cpainter.setHighlightColor(this.colorManager.getColor("SQLEditorPreferencePage.CursorLine"));
            String property = event.getProperty();
            if ("SQLEditorPreferencePage.ColorFindScope".equals(property)) {
                this.initializeFindScopeColor((ISourceViewer)this.sqlViewer);
            }
            this.sqlViewer.invalidateTextPresentation();
        }
        if (event.getProperty().equals("PreferencePage.MaxHistory")) {
            try {
                this.historyManager.removeOverHistory();
            }
            catch (IOException e) {
                DbPlugin.log(e);
            }
        }
    }

    public void setFocus() {
        if (this.sqlViewer != null) {
            DbPlugin.setSecondarlyId(this.getViewSite().getSecondaryId());
            this.sqlViewer.getControl().setFocus();
            this.setGlobalAction();
            if (this.toolBar != null && this.toolBar.getConfig() != null) {
                this.changeTitleImageAndCommitModeText(this.toolBar.getConfig());
            }
        }
        IViewPart view = DbPlugin.findView("zigen.plugin.db.ui.views.HistoryView");
        if (this.showHistoryViewAction != null) {
            if (view != null) {
                this.showHistoryViewAction.setChecked(true);
            } else {
                this.showHistoryViewAction.setChecked(false);
            }
        }
        DbPlugin.fireStatusChangeListener(this, 13);
    }

    public final void updateHistoryButton() {
        this.toolBar.updateHistoryButton();
    }

    public void setCommitMode(IDBConfig config, boolean autoCommit) {
        this.toolBar.setCommitMode(config, autoCommit);
    }

    protected void makeActions() {
        this.explainForQueryAction = new ExplainForQueryAction(this.sqlViewer);
        this.openViewAction = new OpenViewAction(this, this.getViewSite().getWorkbenchWindow());
        this.openViewAction.setDbConfig(this.getConfig());
    }

    protected void updateSelectionDependentActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    protected void updateAction(String actionId) {
        IAction action = (IAction)this.fGlobalActions.get(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected void setGlobalAction() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        ResourceBundle bundle = DbPlugin.getDefault().getResourceBundle();
        this.setGlobalAction(actionBars, ActionFactory.UNDO.getId(), (IAction)new GlobalAction((TextViewer)this.sqlViewer, 1));
        this.setGlobalAction(actionBars, ActionFactory.REDO.getId(), (IAction)new GlobalAction((TextViewer)this.sqlViewer, 2));
        this.setGlobalAction(actionBars, ActionFactory.DELETE.getId(), (IAction)new GlobalAction((TextViewer)this.sqlViewer, 6));
        this.setGlobalAction(actionBars, ActionFactory.SELECT_ALL.getId(), (IAction)new GlobalAction((TextViewer)this.sqlViewer, 7));
        this.setGlobalAction(actionBars, ActionFactory.COPY.getId(), (IAction)new GlobalAction((TextViewer)this.sqlViewer, 4));
        this.setGlobalAction(actionBars, ActionFactory.PASTE.getId(), (IAction)new GlobalAction((TextViewer)this.sqlViewer, 5));
        this.setGlobalAction(actionBars, ActionFactory.CUT.getId(), (IAction)new GlobalAction((TextViewer)this.sqlViewer, 3));
        this.setGlobalAction(actionBars, "zigen.plugin.db.actions.SQLExecuteAction", (IAction)new GlobalAction((TextViewer)this.sqlViewer, 1003));
        this.setGlobalAction(actionBars, "zigen.plugin.db.actions.SQLCurrentExecuteAction", (IAction)new GlobalAction((TextViewer)this.sqlViewer, 1004));
        this.setGlobalAction(actionBars, "zigen.plugin.db.actions.SQLSelectedExecuteAction", (IAction)new GlobalAction((TextViewer)this.sqlViewer, 1005));
        this.setGlobalAction(actionBars, "zigen.plugin.db.actions.SQLBackAction", (IAction)new GlobalAction((TextViewer)this.sqlViewer, 1007));
        this.setGlobalAction(actionBars, "zigen.plugin.db.actions.SQLNextAction", (IAction)new GlobalAction((TextViewer)this.sqlViewer, 1006));
        FindReplaceAction findReplaceAction = new FindReplaceAction(bundle, "find_replace_action_", (IWorkbenchPart)this);
        findReplaceAction.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        this.setGlobalAction(actionBars, ActionFactory.FIND.getId(), (IAction)findReplaceAction);
        this.fSelectionActions.add(ActionFactory.CUT.getId());
        this.fSelectionActions.add(ActionFactory.COPY.getId());
        this.fSelectionActions.add(ActionFactory.PASTE.getId());
        this.fSelectionActions.add(ActionFactory.FIND.getId());
        actionBars.updateActionBars();
    }

    protected void setGlobalAction(IActionBars actionBars, String actionID, IAction action) {
        this.fGlobalActions.put(actionID, action);
        actionBars.setGlobalActionHandler(actionID, action);
    }

    public boolean isEditorInputModifiable() {
        return true;
    }

    public boolean validateEditorInputState() {
        return true;
    }

    private void initializeFindScopeColor(ISourceViewer viewer) {
        IPreferenceStore store = DbPlugin.getDefault().getPreferenceStore();
        if (store != null) {
            Color color = this.colorManager.getColor("SQLEditorPreferencePage.ColorFindScope");
            IFindReplaceTarget target = viewer.getFindReplaceTarget();
            if (target != null && target instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)target).setScopeHighlightColor(color);
            }
            if (this.fFindScopeHighlightColor != null) {
                this.fFindScopeHighlightColor.dispose();
            }
            this.fFindScopeHighlightColor = color;
        }
    }

    private void setExtensionPoint() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(String.valueOf(DbPlugin.getDefault().getBundle().getSymbolicName()) + ".selection");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (elements[j].getName().equals("contributor")) {
                    try {
                        ISelectionListener listener = (ISelectionListener)elements[j].createExecutableExtension("class");
                        this.getViewSite().getPage().addSelectionListener(listener);
                        this.extensionList.add(listener);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void statusChanged(Object obj, int status) {
        block16: {
            block15: {
                if (!(obj instanceof HistoryView)) break block15;
                switch (status) {
                    case 13: {
                        if (this.showHistoryViewAction != null) {
                            this.showHistoryViewAction.setChecked(true);
                            break;
                        }
                        break block16;
                    }
                    case 12: {
                        if (this.showHistoryViewAction != null) {
                            this.showHistoryViewAction.setChecked(false);
                            break;
                        }
                        break block16;
                    }
                }
                break block16;
            }
            if (obj instanceof CommitModeAction) {
                CommitModeAction action = (CommitModeAction)((Object)obj);
                switch (status) {
                    case 102: {
                        this.toolBar.setCommitMode(action.getDbConfig(), action.isAutoCommit);
                        this.changeTitleImageAndCommitModeText(action.getDbConfig());
                        break;
                    }
                }
            } else if (obj instanceof IDBConfig && status == 106) {
                this.toolBar.updateCombo((IDBConfig)obj);
                this.changeTitleImageAndCommitModeText((IDBConfig)obj);
            }
        }
        if (status == 101) {
            this.toolBar.updateHistoryButton();
        } else if (status == 107) {
            this.toolBar.initializeSelectCombo();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object obj;
        if (selection != null && selection instanceof StructuredSelection && (obj = ((StructuredSelection)selection).getFirstElement()) != null) {
            IDBConfig config = null;
            if (obj instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)obj;
                Object o = adaptable.getAdapter(IResource.class);
                if (o instanceof IProject) {
                    config = ProjectUtil.getDBConfig((IProject)o);
                } else if (o instanceof IFolder) {
                    config = ResourceUtil.getDBConfig((IResource)((IFolder)o));
                } else if (o instanceof IFile) {
                    config = ResourceUtil.getDBConfig((IResource)((IFile)o));
                }
            } else if (obj instanceof TreeNode) {
                config = ((TreeNode)obj).getDbConfig();
            }
            if (config != null) {
                this.toolBar.updateCombo(config);
                this.changeTitleImageAndCommitModeText(config);
            }
        }
    }

    public void selectionChangeHandler(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof TextSelection) {
            TextSelection textSelection = (TextSelection)selection;
            if (textSelection.getLength() > 0) {
                if (this.toolBar.getConfig() != null && this.toolBar.getConfig().getDbType() == 1) {
                    this.explainForQueryAction.setEnabled(true);
                }
            } else {
                this.explainForQueryAction.setEnabled(false);
            }
        } else {
            this.explainForQueryAction.setEnabled(false);
        }
    }

    public boolean isLockedDataBase() {
        if (this.toolBar != null) {
            return this.toolBar.isLockedDataBase();
        }
        return false;
    }

    public void setLockedDataBase(boolean isLocked) {
        if (this.toolBar != null) {
            this.toolBar.setLockedDataBase(isLocked);
        }
    }

    public Object getAdapter(Class required) {
        if (IFindReplaceTarget.class.equals((Object)required)) {
            IFindReplaceTarget target = this.sqlViewer.getFindReplaceTarget();
            if (target instanceof IFindReplaceTargetExtension) {
                IFindReplaceTargetExtension t = (IFindReplaceTargetExtension)target;
                if (this.fFindScopeHighlightColor != null) {
                    t.setScopeHighlightColor(this.fFindScopeHighlightColor);
                }
            }
            return target;
        }
        if (Widget.class.equals((Object)required)) {
            return this.sqlViewer.getTextWidget();
        }
        return null;
    }
}

