/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views.internal;

import java.io.File;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.PartInitException;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SQLFormatter;
import zigen.plugin.db.core.SQLHistory;
import zigen.plugin.db.core.SQLHistoryManager;
import zigen.plugin.db.core.SQLTokenizer;
import zigen.plugin.db.core.StringUtil;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ui.actions.ExecuteCurrentSQLAction;
import zigen.plugin.db.ui.actions.ExecuteSQLAction;
import zigen.plugin.db.ui.actions.ExecuteScriptAction;
import zigen.plugin.db.ui.actions.ExecuteSelectedSQLAction;
import zigen.plugin.db.ui.jobs.SqlFormatJob;
import zigen.plugin.db.ui.views.ISQLOperationTarget;
import zigen.plugin.db.ui.views.SQLExecuteView;
import zigen.plugin.db.ui.views.internal.Messages;

public class SQLSourceViewer
extends ProjectionViewer
implements ISQLOperationTarget {
    SQLHistoryManager mgr = DbPlugin.getDefault().getHistoryManager();
    protected IDBConfig config;
    protected String secondaryId;
    protected IPreferenceStore preferenceStore = DbPlugin.getDefault().getPreferenceStore();
    protected String sqlFileName;
    protected boolean isFormatPreExecute;

    public SQLSourceViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles) {
        super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
        super.appendVerifyKeyListener((VerifyKeyListener)new VerifyKeyAdapter());
    }

    protected SQLExecuteView getSQLExecuteView() {
        try {
            return (SQLExecuteView)DbPlugin.findView("zigen.plugin.db.ui.views.SQLExecuteView", this.secondaryId);
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean canDoOperation(int operation) {
        if (this.getTextWidget() == null || !this.redraws() && operation != 1001) {
            return false;
        }
        switch (operation) {
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 1007: 
            case 1008: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 1013: {
                return this.isEditable();
            }
        }
        return super.canDoOperation(operation);
    }

    public void doOperation(int operation) {
        if (this.getTextWidget() == null || !this.redraws() && operation != 1001) {
            return;
        }
        switch (operation) {
            case 1001: {
                this.doFormat();
                return;
            }
            case 1002: {
                this.doUnFormat();
                return;
            }
            case 1003: {
                this.doAllSQLExecute();
                return;
            }
            case 1004: {
                this.doCurrentSQLExecute();
                return;
            }
            case 1005: {
                this.doSelectedSQLExecute();
                return;
            }
            case 1013: {
                this.doScriptExecute();
                return;
            }
            case 1006: {
                this.doNextSQL();
                return;
            }
            case 1007: {
                this.doBackSQL();
                return;
            }
            case 1008: {
                this.doLineDelete();
                return;
            }
            case 1009: {
                this.doComment();
                return;
            }
            case 1010: {
                this.doCommit();
                return;
            }
            case 1011: {
                this.doRollback();
                return;
            }
            case 1012: {
                this.doAllClear();
                return;
            }
        }
        super.doOperation(operation);
    }

    protected void doAllSQLExecute() {
        SQLExecuteView view = this.getSQLExecuteView();
        if (view != null && this.isFormatPreExecute) {
            this.setEditable(false);
            SqlFormatJob job = new SqlFormatJob(this, this.secondaryId);
            job.setPriority(20);
            job.setUser(false);
            job.schedule();
        }
        this.getTextWidget().getCaretOffset();
        Display display = Display.getDefault();
        display.syncExec((Runnable)new ExecuteSQLAction(this.config, this, this.secondaryId));
    }

    protected void doCurrentSQLExecute() {
        SQLExecuteView view = this.getSQLExecuteView();
        if (view != null && this.isFormatPreExecute) {
            this.setEditable(false);
            SqlFormatJob job = new SqlFormatJob(this, this.secondaryId);
            job.setPriority(20);
            job.setUser(false);
            job.schedule();
        }
        Display display = Display.getDefault();
        display.syncExec((Runnable)new ExecuteCurrentSQLAction(this.config, this, this.secondaryId));
    }

    protected void doSelectedSQLExecute() {
        TextSelection selection = (TextSelection)this.getSelection();
        SQLExecuteView view = this.getSQLExecuteView();
        if (view != null && this.isFormatPreExecute) {
            this.setEditable(false);
            SqlFormatJob job = new SqlFormatJob(this, this.secondaryId);
            job.setPriority(20);
            job.setUser(false);
            job.schedule();
        }
        Display display = Display.getDefault();
        ExecuteSelectedSQLAction action = new ExecuteSelectedSQLAction(this.config, this, this.secondaryId, selection);
        display.syncExec((Runnable)action);
    }

    protected void doScriptExecute() {
        SQLExecuteView view = this.getSQLExecuteView();
        if (view != null && this.isFormatPreExecute) {
            this.doFormat();
        }
        IDocument doc = this.getDocument();
        Display display = Display.getDefault();
        display.syncExec((Runnable)new ExecuteScriptAction(this.config, doc, this.secondaryId));
    }

    protected void doUnFormat() {
        try {
            String preSql = this.getDocument().get();
            String formatSql = this.getUnFormatSQL(preSql);
            this.getDocument().replace(0, preSql.length(), formatSql);
            this.setSelectedRange(formatSql.length(), 0);
        }
        catch (MalformedTreeException e) {
            DbPlugin.log(e);
        }
        catch (BadLocationException e) {
            DbPlugin.log(e);
        }
    }

    protected void doFormat() {
        this.setEditable(false);
        SqlFormatJob job = new SqlFormatJob(this, this.secondaryId);
        job.setPriority(20);
        job.setUser(false);
        job.schedule();
    }

    private String getUnFormatSQL(String preSql) {
        String demiliter = this.preferenceStore.getString("SQLEditorPreferencePage.SqlDemiliter");
        StringBuffer sb = new StringBuffer();
        SQLTokenizer st = new SQLTokenizer(preSql, demiliter);
        while (st.hasMoreElements()) {
            String sql = (String)st.nextElement();
            if (sql == null || sql.length() <= 0) continue;
            sb.append(SQLFormatter.unformat(sql));
            if ("/".equals(demiliter)) {
                sb.append(DbPluginConstant.LINE_SEP);
            }
            sb.append(demiliter);
            sb.append(DbPluginConstant.LINE_SEP);
        }
        return sb.toString();
    }

    protected void doLineDelete() {
        try {
            IDocument doc = this.getDocument();
            int offset = this.getTextWidget().getCaretOffset();
            TextSelection tSelection = (TextSelection)this.getSelection();
            int startLine = tSelection.getStartLine();
            int endLine = tSelection.getEndLine();
            int startOffset = doc.getLineInformation(startLine).getOffset();
            int endOffset = doc.getLineInformation(endLine).getOffset() + doc.getLineInformation(endLine).getLength();
            String demiliter = doc.getLineDelimiter(endLine);
            int length = endOffset - startOffset;
            if (demiliter != null) {
                doc.replace(startOffset, length + demiliter.length(), "");
            } else {
                doc.replace(startOffset, length, "");
            }
            Position pos = new Position(offset);
            doc.removePosition(pos);
        }
        catch (MalformedTreeException e) {
            DbPlugin.log(e);
        }
        catch (BadLocationException e) {
            DbPlugin.log(e);
        }
    }

    protected void doComment() {
        try {
            IDocument doc = this.getDocument();
            int offset = this.getTextWidget().getCaretOffset();
            String select = this.getTextWidget().getSelectionText();
            if (select == null || "".equals(select)) {
                IRegion region = doc.getLineInformationOfOffset(offset);
                String lineStr = doc.get(region.getOffset(), region.getLength());
                String wk = lineStr.trim();
                if (wk.startsWith("/*") && wk.endsWith("*/")) {
                    int start = region.getOffset() + lineStr.indexOf("/*");
                    int end = region.getOffset() + lineStr.lastIndexOf("*/");
                    MultiTextEdit multiTextEdit = new MultiTextEdit();
                    multiTextEdit.addChild((TextEdit)new DeleteEdit(start, 2));
                    multiTextEdit.addChild((TextEdit)new DeleteEdit(end, 2));
                    multiTextEdit.apply(doc);
                } else {
                    int start = region.getOffset();
                    int end = region.getOffset() + region.getLength();
                    MultiTextEdit multiTextEdit = new MultiTextEdit();
                    multiTextEdit.addChild((TextEdit)new InsertEdit(start += StringUtil.firstWordPosition(lineStr), "/*"));
                    multiTextEdit.addChild((TextEdit)new InsertEdit(end, "*/"));
                    multiTextEdit.apply(doc);
                }
            } else {
                Point selectedRange = this.getSelectedRange();
                IRegion startRegion = doc.getLineInformationOfOffset(selectedRange.x);
                IRegion endRegion = doc.getLineInformationOfOffset(selectedRange.x + selectedRange.y);
                String startLineStr = doc.get(startRegion.getOffset(), startRegion.getLength());
                String endLineStr = doc.get(endRegion.getOffset(), endRegion.getLength());
                String beginWk = startLineStr.trim();
                String endWk = endLineStr.trim();
                if (beginWk.startsWith("/*") && endWk.endsWith("*/")) {
                    int start = startRegion.getOffset() + startLineStr.indexOf("/*");
                    int end = endRegion.getOffset() + endLineStr.lastIndexOf("*/");
                    MultiTextEdit multiTextEdit = new MultiTextEdit();
                    multiTextEdit.addChild((TextEdit)new DeleteEdit(start, 2));
                    multiTextEdit.addChild((TextEdit)new DeleteEdit(end, 2));
                    multiTextEdit.apply(doc);
                } else {
                    int start = startRegion.getOffset();
                    int end = endRegion.getOffset() + endRegion.getLength();
                    MultiTextEdit multiTextEdit = new MultiTextEdit();
                    multiTextEdit.addChild((TextEdit)new InsertEdit(start += StringUtil.firstWordPosition(startLineStr), "/*"));
                    multiTextEdit.addChild((TextEdit)new InsertEdit(end, "*/"));
                    multiTextEdit.apply(doc);
                }
            }
        }
        catch (MalformedTreeException e) {
            DbPlugin.log(e);
        }
        catch (BadLocationException e) {
            DbPlugin.log(e);
        }
    }

    public void doNextSQL() {
        SQLHistory history = this.mgr.nextHisotry();
        if (history != null) {
            this.getDocument().set(this.mgr.loadContents(history));
            this.setSelectedRange(history.getSql().length(), 0);
            this.invalidateTextPresentation();
        } else {
            this.getDocument().set("");
        }
        DbPlugin.fireStatusChangeListener(this, 101);
    }

    public void doBackSQL() {
        SQLHistory history = this.mgr.prevHisotry();
        if (history != null) {
            this.getDocument().set(this.mgr.loadContents(history));
            this.setSelectedRange(history.getSql().length(), 0);
            this.invalidateTextPresentation();
        } else {
            this.getDocument().set("");
        }
        DbPlugin.fireStatusChangeListener(this, 101);
    }

    protected void doCommit() {
        try {
            Transaction trans = Transaction.getInstance(this.config);
            if (!trans.isConneting()) {
                DbPlugin.getDefault().showWarningMessage(DbPluginConstant.MSG_NO_CONNECTED_DB);
                return;
            }
            SQLExecuteView view = this.getSQLExecuteView();
            if (view != null) {
                int transCount = trans.getTransactionCount();
                trans.commit();
                StringBuffer sb = new StringBuffer();
                sb.append(transCount);
                sb.append(Messages.getString("SQLSourceViewer.21"));
                view.setStatusMessage(sb.toString());
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    protected void doRollback() {
        try {
            Transaction trans = Transaction.getInstance(this.config);
            if (!trans.isConneting()) {
                DbPlugin.getDefault().showWarningMessage(DbPluginConstant.MSG_NO_CONNECTED_DB);
                return;
            }
            SQLExecuteView view = this.getSQLExecuteView();
            if (view != null) {
                int transCount = trans.getTransactionCount();
                trans.rollback();
                StringBuffer sb = new StringBuffer();
                sb.append(transCount);
                sb.append(Messages.getString("SQLSourceViewer.22"));
                view.setStatusMessage(sb.toString());
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    protected void doAllClear() {
        this.getDocument().set("");
    }

    public IDBConfig getDbConfig() {
        return this.config;
    }

    public void setDbConfig(IDBConfig config) {
        this.config = config;
    }

    public void setSecondaryId(String secondaryId) {
        this.secondaryId = secondaryId;
    }

    public String getSqlFileName() {
        return this.sqlFileName;
    }

    public void setSqlFile(File sqlFile) {
        this.sqlFileName = sqlFile.getName();
    }

    public void setSqlFileName(String fileName) {
        this.sqlFileName = fileName;
    }

    public boolean isFormatPreExecute() {
        return this.isFormatPreExecute;
    }

    public void setFormatPreExecute(boolean isFormatPreExecute) {
        this.isFormatPreExecute = isFormatPreExecute;
    }

    public class VerifyKeyAdapter
    implements VerifyKeyListener {
        public void verifyKey(VerifyEvent event) {
            if (event.character == '\r') {
                try {
                    IRegion region;
                    String wk;
                    char c;
                    String demiliter = DbPlugin.getDefault().getPreferenceStore().getString("SQLEditorPreferencePage.SqlDemiliter");
                    IDocument doc = SQLSourceViewer.this.getDocument();
                    StyledText text = SQLSourceViewer.this.getTextWidget();
                    int offset = text.getCaretOffset();
                    if (offset > 0 && demiliter.equals(new String(new char[]{c = doc.getChar(offset - 1)})) && (wk = doc.get((region = doc.getLineInformationOfOffset(offset)).getOffset(), region.getLength() - 1).trim()).length() == 0) {
                        doc.replace(region.getOffset(), region.getLength() - 1, "");
                    }
                    event.doit = true;
                }
                catch (BadLocationException e) {
                    DbPlugin.log(e);
                }
            }
            if (event.stateMask == 262144 && event.character == ' ') {
                if (SQLSourceViewer.this.canDoOperation(13)) {
                    SQLSourceViewer.this.doOperation(13);
                }
                event.doit = false;
            }
            if (event.stateMask == 262144 && event.keyCode == 100) {
                if (SQLSourceViewer.this.canDoOperation(1008)) {
                    SQLSourceViewer.this.doOperation(1008);
                }
                event.doit = false;
            }
            if (event.stateMask == 393216 && event.keyCode == 102) {
                if (SQLSourceViewer.this.canDoOperation(1001)) {
                    SQLSourceViewer.this.doOperation(1001);
                }
                event.doit = false;
            }
            if (event.stateMask == 393216 && event.keyCode == 117) {
                if (SQLSourceViewer.this.canDoOperation(1002)) {
                    SQLSourceViewer.this.doOperation(1002);
                }
                event.doit = false;
            }
            if (event.stateMask == 262144 && event.keyCode == 47) {
                if (SQLSourceViewer.this.canDoOperation(1009)) {
                    SQLSourceViewer.this.doOperation(1009);
                }
                event.doit = false;
            }
        }
    }
}

