/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views.internal;

import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.PluginSettingsManager;
import zigen.plugin.db.core.DBConfigManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SQLHistoryManager;
import zigen.plugin.db.ui.actions.GlobalAction;
import zigen.plugin.db.ui.actions.LockDataBaseAction;
import zigen.plugin.db.ui.actions.OpenSQLAction;
import zigen.plugin.db.ui.actions.SaveSQLAction;
import zigen.plugin.db.ui.actions.ShowHistoryViewAction;
import zigen.plugin.db.ui.views.CommitModeAction;
import zigen.plugin.db.ui.views.FormatModeAction;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;

public class SQLToolBar {
    protected PluginSettingsManager pluginMgr = DbPlugin.getDefault().getPluginSettingsManager();
    protected SQLHistoryManager historyManager = DbPlugin.getDefault().getHistoryManager();
    protected IDBConfig[] configs;
    protected SQLSourceViewer fSourceViewer;
    protected CoolBar coolBar;
    protected Combo selectCombo;
    protected ComboContributionItem comboContributionItem = new ComboContributionItem("SelectDataBase");
    protected GlobalAction allExecAction = new GlobalAction(null, 1003);
    protected GlobalAction currExecAction = new GlobalAction(null, 1004);
    protected GlobalAction selectExecAction = new GlobalAction(null, 1005);
    protected GlobalAction scriptExecAction = new GlobalAction(null, 1013);
    protected GlobalAction allClearAction = new GlobalAction(null, 1012);
    protected GlobalAction nextSqlAction = new GlobalAction(null, 1006);
    protected GlobalAction backSqlAction = new GlobalAction(null, 1007);
    protected GlobalAction formatSqlAction = new GlobalAction(null, 1001);
    protected GlobalAction commitAction = new GlobalAction(null, 1010);
    protected GlobalAction rollbackAction = new GlobalAction(null, 1011);
    protected OpenSQLAction openAction = new OpenSQLAction(null);
    protected SaveSQLAction saveAction = new SaveSQLAction(null);
    protected CommitModeAction commitModeAction = new CommitModeAction(null);
    protected FormatModeAction formatModeAction = new FormatModeAction(null);
    protected ShowHistoryViewAction showHistoryViewAction = new ShowHistoryViewAction();
    protected LockDataBaseAction lockDataBaseAction = new LockDataBaseAction(null);
    String lastSelectedDB;
    boolean lastAutoFormatMode;

    protected ToolBarContributionItem getToolBarContributionItem1(CoolBarManager coolBarMgr) {
        ToolBarManager toolBarMgr = new ToolBarManager(0x800000);
        toolBarMgr.add((IAction)this.openAction);
        toolBarMgr.add((IAction)this.saveAction);
        return new ToolBarContributionItem((IToolBarManager)toolBarMgr);
    }

    protected ToolBarContributionItem getToolBarContributionItem2(CoolBarManager coolBarMgr) {
        ToolBarManager toolBarMgr = new ToolBarManager(0x800000);
        toolBarMgr.add((IAction)this.allExecAction);
        toolBarMgr.add((IAction)this.scriptExecAction);
        toolBarMgr.add((IAction)this.allClearAction);
        return new ToolBarContributionItem((IToolBarManager)toolBarMgr);
    }

    protected ToolBarContributionItem getToolBarContributionItem3(CoolBarManager coolBarMgr) {
        ToolBarManager toolBarMgr = new ToolBarManager(0x800000);
        toolBarMgr.add((IAction)this.backSqlAction);
        toolBarMgr.add((IAction)this.nextSqlAction);
        return new ToolBarContributionItem((IToolBarManager)toolBarMgr);
    }

    protected ToolBarContributionItem getToolBarContributionItem4(CoolBarManager coolBarMgr) {
        ToolBarManager toolBarMgr = new ToolBarManager(0x800000);
        toolBarMgr.add((IAction)this.commitModeAction);
        toolBarMgr.add((IAction)this.commitAction);
        toolBarMgr.add((IAction)this.rollbackAction);
        return new ToolBarContributionItem((IToolBarManager)toolBarMgr);
    }

    protected ToolBarContributionItem getToolBarContributionItem5(CoolBarManager coolBarMgr) {
        ToolBarManager toolBarMgr = new ToolBarManager(0x800000);
        toolBarMgr.add((IAction)this.formatModeAction);
        return new ToolBarContributionItem((IToolBarManager)toolBarMgr);
    }

    protected ToolBarContributionItem getToolBarContributionItem6(CoolBarManager coolBarMgr) {
        ToolBarManager toolBarMgr = new ToolBarManager(0x800000);
        toolBarMgr.add((IContributionItem)this.comboContributionItem);
        toolBarMgr.add((IAction)this.lockDataBaseAction);
        return new ToolBarContributionItem((IToolBarManager)toolBarMgr);
    }

    public void createPartControl(final Composite parent) {
        this.coolBar = new CoolBar(parent, 0x800000);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.coolBar.setLayoutData((Object)data);
        CoolBarManager coolBarMgr = new CoolBarManager(this.coolBar);
        coolBarMgr.add((IContributionItem)this.getToolBarContributionItem1(coolBarMgr));
        coolBarMgr.add((IContributionItem)this.getToolBarContributionItem2(coolBarMgr));
        coolBarMgr.add((IContributionItem)this.getToolBarContributionItem3(coolBarMgr));
        coolBarMgr.add((IContributionItem)this.getToolBarContributionItem4(coolBarMgr));
        coolBarMgr.add((IContributionItem)this.getToolBarContributionItem5(coolBarMgr));
        coolBarMgr.add((IContributionItem)this.getToolBarContributionItem6(coolBarMgr));
        coolBarMgr.update(true);
        this.coolBar.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                parent.getParent().layout(true);
                parent.layout(true);
            }
        });
    }

    public void setSQLSourceViewer(SQLSourceViewer sqlSourceViewer) {
        this.fSourceViewer = sqlSourceViewer;
        this.openAction.setSQLSourceViewer(sqlSourceViewer);
        this.saveAction.setSQLSourceViewer(sqlSourceViewer);
        this.nextSqlAction.setTextViewer((TextViewer)sqlSourceViewer);
        this.backSqlAction.setTextViewer((TextViewer)sqlSourceViewer);
        this.allExecAction.setTextViewer((TextViewer)sqlSourceViewer);
        this.currExecAction.setTextViewer((TextViewer)sqlSourceViewer);
        this.selectExecAction.setTextViewer((TextViewer)sqlSourceViewer);
        this.scriptExecAction.setTextViewer((TextViewer)sqlSourceViewer);
        this.allClearAction.setTextViewer((TextViewer)sqlSourceViewer);
        this.formatModeAction.setSQLSourceViewer(sqlSourceViewer);
        this.commitModeAction.setSQLSourceViewer(sqlSourceViewer);
        this.commitAction.setTextViewer((TextViewer)sqlSourceViewer);
        this.rollbackAction.setTextViewer((TextViewer)sqlSourceViewer);
    }

    public final void updateHistoryButton() {
        if (this.historyManager.hasPrevHistory()) {
            if (this.backSqlAction != null) {
                this.backSqlAction.setEnabled(true);
            }
        } else if (this.backSqlAction != null) {
            this.backSqlAction.setEnabled(false);
        }
        if (this.historyManager.hasNextHistory()) {
            if (this.nextSqlAction != null) {
                this.nextSqlAction.setEnabled(true);
            }
        } else if (this.nextSqlAction != null) {
            this.nextSqlAction.setEnabled(false);
        }
    }

    public void updateCombo(IDBConfig config) {
        if (!this.lockDataBaseAction.isChecked()) {
            this.comboContributionItem.updateCombo(config);
        }
    }

    public void initializeSelectCombo() {
        this.comboContributionItem.initializeSelectCombo();
    }

    public void setCommitMode(IDBConfig targetConfig, boolean autoCommit) {
        this.comboContributionItem.setCommitMode(targetConfig, autoCommit);
    }

    public ComboContributionItem getComboContributionItem() {
        return this.comboContributionItem;
    }

    public IDBConfig getConfig() {
        return this.comboContributionItem.selectedConfig();
    }

    public IDBConfig[] getConfigs() {
        return this.configs;
    }

    public CoolBar getCoolBar() {
        return this.coolBar;
    }

    public SQLSourceViewer getFSourceViewer() {
        return this.fSourceViewer;
    }

    public Combo getSelectCombo() {
        return this.selectCombo;
    }

    public boolean isLockedDataBase() {
        return this.lockDataBaseAction.isChecked();
    }

    public void setLockedDataBase(boolean isLocked) {
        this.lockDataBaseAction.setChecked(isLocked);
    }

    class ComboContributionItem
    extends ControlContribution {
        boolean isSaveLastDb;

        public ComboContributionItem(String id) {
            super(id);
            this.isSaveLastDb = false;
        }

        public void setSaveLastDb(boolean isSave) {
            this.isSaveLastDb = isSave;
        }

        protected Control createControl(Composite parent) {
            SQLToolBar.this.selectCombo = new Combo(parent, 8);
            GridData data = new GridData(768);
            data.widthHint = 200;
            SQLToolBar.this.selectCombo.setLayoutData((Object)data);
            SQLToolBar.this.lastSelectedDB = this.getLastSelectedDBName();
            this.initializeSelectCombo();
            SQLToolBar.this.selectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IDBConfig config = SQLToolBar.this.getConfig();
                    if (((ComboContributionItem)ComboContributionItem.this).SQLToolBar.this.fSourceViewer != null) {
                        ComboContributionItem.this.updateCombo(config);
                    }
                    if (ComboContributionItem.this.isSaveLastDb) {
                        ((ComboContributionItem)ComboContributionItem.this).SQLToolBar.this.lastSelectedDB = config.getDbName();
                        ComboContributionItem.this.setLastSelectedDBName(((ComboContributionItem)ComboContributionItem.this).SQLToolBar.this.lastSelectedDB);
                    }
                    DbPlugin.fireStatusChangeListener(config, 106);
                }
            });
            return SQLToolBar.this.selectCombo;
        }

        String getLastSelectedDBName() {
            Object obj = SQLToolBar.this.pluginMgr.getValue("KEY_DEFAULT_DB");
            if (obj != null) {
                return (String)obj;
            }
            return null;
        }

        void setLastSelectedDBName(String dbName) {
            SQLToolBar.this.pluginMgr.setValue("KEY_DEFAULT_DB", dbName);
        }

        void initializeSelectCombo() {
            IDBConfig config = SQLToolBar.this.getConfig();
            SQLToolBar.this.selectCombo.removeAll();
            SQLToolBar.this.configs = DBConfigManager.getDBConfigs();
            int i = 0;
            while (i < SQLToolBar.this.configs.length) {
                IDBConfig w_config = SQLToolBar.this.configs[i];
                SQLToolBar.this.selectCombo.add(String.valueOf(w_config.getSchema()) + " : " + w_config.getDbName() + "  ");
                if (SQLToolBar.this.lastSelectedDB != null && SQLToolBar.this.lastSelectedDB.equals(w_config.getDbName())) {
                    SQLToolBar.this.selectCombo.select(i);
                }
                if (config != null && config.getDbName().equals(w_config.getDbName())) {
                    SQLToolBar.this.selectCombo.select(i);
                }
                ++i;
            }
        }

        void updateCombo(IDBConfig newConfig) {
            if (newConfig != null) {
                IDBConfig config = null;
                int i = 0;
                while (i < SQLToolBar.this.configs.length) {
                    IDBConfig w_config = SQLToolBar.this.configs[i];
                    if (newConfig != null && newConfig.getDbName().equals(w_config.getDbName())) {
                        config = w_config;
                        SQLToolBar.this.selectCombo.select(i);
                    }
                    ++i;
                }
                if (SQLToolBar.this.fSourceViewer != null && config != null) {
                    SQLToolBar.this.fSourceViewer.setDbConfig(config);
                    SQLToolBar.this.commitModeAction.setSQLSourceViewer(SQLToolBar.this.fSourceViewer);
                    SQLToolBar.this.comboContributionItem.setCommitMode(newConfig, config.isAutoCommit());
                }
            } else {
                SQLToolBar.this.selectCombo.select(-1);
            }
        }

        private void setCommitMode(IDBConfig targetConfig, boolean isAutoCommit) {
            IDBConfig config = SQLToolBar.this.getConfig();
            if (config == null || config.getDbName().equals(targetConfig.getDbName())) {
                SQLToolBar.this.commitAction.setEnabled(!isAutoCommit);
                SQLToolBar.this.rollbackAction.setEnabled(!isAutoCommit);
                SQLToolBar.this.commitModeAction.setCommitMode(isAutoCommit);
            }
        }

        public IDBConfig selectedConfig() {
            int index = SQLToolBar.this.selectCombo.getSelectionIndex();
            if (index >= 0) {
                return SQLToolBar.this.configs[index];
            }
            return null;
        }
    }
}

