/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import zigen.plugin.db.core.PatternUtil;
import zigen.plugin.db.ui.internal.TreeLeaf;

public class ElementFilter
extends ViewerFilter {
    boolean regularExpressions = false;
    boolean caseSensitive = false;
    String text;
    Pattern pattern = null;

    public ElementFilter(String text, boolean regularExpressions, boolean canSensitive) {
        this.text = text;
        this.caseSensitive = canSensitive;
        this.createPattern();
    }

    private void createPattern() {
        try {
            this.pattern = this.regularExpressions ? (!this.caseSensitive ? Pattern.compile(this.text, 2) : Pattern.compile(this.text)) : PatternUtil.getPattern(this.text, this.caseSensitive);
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (this.text != null && !"".equals(this.text)) {
            if (element instanceof TreeLeaf) {
                TreeLeaf leaf = (TreeLeaf)element;
                if (this.pattern != null) {
                    Matcher mc = this.pattern.matcher(leaf.getName());
                    return !mc.matches();
                }
                return true;
            }
            return true;
        }
        return true;
    }
}

