/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.MultiPageEditorPart;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ui.actions.CopyRecordDataAction;
import zigen.plugin.db.ui.actions.ITableViewEditorAction;
import zigen.plugin.db.ui.actions.SelectAllRecordAction;
import zigen.plugin.db.ui.editors.IQueryViewEditor;
import zigen.plugin.db.ui.editors.ITableViewEditor;
import zigen.plugin.db.ui.editors.Messages;
import zigen.plugin.db.ui.editors.QueryViewEditorInput;
import zigen.plugin.db.ui.editors.QueryViewerContributor;
import zigen.plugin.db.ui.editors.TableViewContentProvider;
import zigen.plugin.db.ui.editors.TableViewLabelProvider;
import zigen.plugin.db.ui.editors.TextCellEditor;
import zigen.plugin.db.ui.editors.event.TableDefaultSortListener;
import zigen.plugin.db.ui.editors.event.TableKeyAdapter;
import zigen.plugin.db.ui.editors.event.TableKeyEventHandler;
import zigen.plugin.db.ui.editors.event.TableSortListener;
import zigen.plugin.db.ui.editors.internal.CellEditorType;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.jobs.ChangeColorJob;
import zigen.plugin.db.ui.jobs.RecordCountForQueryJob;
import zigen.plugin.db.ui.jobs.SqlExecJob;
import zigen.plugin.db.ui.views.StatusLineContributionItem;

public class QueryViewEditor2
extends MultiPageEditorPart
implements ITableViewEditor,
IQueryViewEditor {
    private ImageCacher ic = ImageCacher.getInstance();
    private Table table;
    private TableViewer viewer;
    private TableElement[] elements;
    private String query;
    private IDBConfig config = null;
    private TableSortListener sortListener;
    protected StatusLineContributionItem responseTimeItem;
    protected String responseTime;
    protected SelectAllRecordAction selectAllRecordAction;
    protected CopyRecordDataAction copyAction;
    protected ChangeColorJob changeColorJob;
    protected Label infoLabel;
    TableKeyEventHandler handler;
    CellEditor[] cellEditors;
    private int max_column_size = 600;
    private List extensionList = new ArrayList();

    public void setInfomationText(String message) {
        this.infoLabel.setText(message);
    }

    private void makeActions() {
        this.selectAllRecordAction = new SelectAllRecordAction();
        this.copyAction = new CopyRecordDataAction();
        this.selectAllRecordAction.setActiveEditor(this);
        this.copyAction.setActiveEditor(this);
    }

    protected void createPages() {
        this.makeActions();
        this.createLogPage();
    }

    private void createLogPage() {
        Composite composite = new Composite(this.getContainer(), 0);
        composite.setLayout((Layout)new FillLayout());
        int index = this.addPage((Control)composite);
        this.setPageText(index, "log");
    }

    private boolean hasContributionItem(IStatusLineManager manager, String id) {
        IContributionItem[] items = manager.getItems();
        int i = 0;
        while (i < items.length) {
            IContributionItem item = items[i];
            if (item.getId().equals(id)) {
                this.responseTimeItem = (StatusLineContributionItem)item;
                return true;
            }
            ++i;
        }
        return false;
    }

    public void contributeToStatusLine() {
        IEditorSite site = super.getEditorSite();
        IActionBars actionBars = site.getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (!this.hasContributionItem(manager, "RecordCount")) {
            this.responseTimeItem = new StatusLineContributionItem("RecordCount");
            manager.add((IContributionItem)this.responseTimeItem);
        }
    }

    private void createMessageArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.infoLabel = new Label(composite, 0);
        this.infoLabel.setText("");
        this.infoLabel.setForeground(new Color(null, 255, 0, 0));
        GridData data1 = new GridData(768);
        data1.verticalIndent = 1;
        this.infoLabel.setLayoutData((Object)data1);
        ToolBar toolbar = new ToolBar(composite, 0x800000);
        toolbar.setLayoutData((Object)new GridData(128));
        ToolItem reloeadItem = new ToolItem(toolbar, 0);
        reloeadItem.setImage(this.ic.getImage("refresh.gif"));
        reloeadItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryViewEditorInput ei = (QueryViewEditorInput)QueryViewEditor2.this.getEditorInput();
                Transaction trans = Transaction.getInstance(QueryViewEditor2.this.config);
                SqlExecJob job = new SqlExecJob(trans, QueryViewEditor2.this.query, ei.getSecondarlyId(), true);
                job.setUser(false);
                job.schedule();
            }
        });
    }

    private void createMainPage() {
        Composite main = new Composite(this.getContainer(), 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginHeight = 1;
        gridLayout.marginWidth = 1;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        main.setLayout((Layout)gridLayout);
        this.createMessageArea(main);
        this.table = new Table(main, 68354);
        GridData gridData2 = new GridData(1808);
        this.table.setLayoutData((Object)gridData2);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setFont(DbPlugin.getDefaultFont());
        this.viewer = new TableViewer(this.table);
        this.setHeaderColumn(this.table);
        this.viewer.setContentProvider((IContentProvider)new TableViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableViewLabelProvider());
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B) {
                    int row = QueryViewEditor2.this.handler.getSelectedRow();
                    QueryViewEditor2.this.handler.editTableElement(row, 1);
                }
            }
        });
        this.table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (QueryViewEditor2.this.table.getSelectionIndex() == -1) {
                    QueryViewEditor2.this.table.select(0);
                    QueryViewEditor2.this.table.notifyListeners(13, null);
                }
                IActionBars bars = QueryViewEditor2.this.getEditorSite().getActionBars();
                QueryViewEditor2.this.setGlobalActionForEditor(bars);
                bars.updateActionBars();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                QueryViewEditor2.this.selectionChangeHandler(e);
            }
        });
        this.viewer.setInput((Object)this.elements);
        this.changeColorJob = new ChangeColorJob(this.table);
        this.changeColorJob.setPriority(30);
        this.changeColorJob.setUser(false);
        this.changeColorJob.schedule();
        this.handler = new TableKeyEventHandler(this);
        this.setCellModify(this.viewer, this.handler);
        this.columnsPack(this.table);
        this.hookContextMenu();
        this.contributeToStatusLine();
        this.addPage((Control)main);
        this.setActivePage(this.getPageCount() - 1);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    public void refleshAction() {
        this.copyAction.refresh();
    }

    void selectionChangeHandler(SelectionChangedEvent event) {
        this.refleshAction();
    }

    private void setCellModify(TableViewer viewer, TableKeyEventHandler handler) {
        if (this.elements == null) {
            return;
        }
        final IActionBars bars = this.getEditorSite().getActionBars();
        TableElement element = this.elements[0];
        int size = element.getColumns().length + 1;
        String[] properties = new String[size];
        element.getColumns();
        this.cellEditors = new CellEditor[size];
        TableKeyAdapter keyAdapter = new TableKeyAdapter(handler);
        int i = 0;
        while (i < this.cellEditors.length) {
            properties[i] = String.valueOf(i);
            if (i > 0) {
                TextCellEditor cellEditor = new TextCellEditor(this.table, i);
                if (cellEditor.getControl() instanceof Text) {
                    Text txt = (Text)cellEditor.getControl();
                    txt.setEditable(false);
                }
                cellEditor.getControl().addKeyListener((KeyListener)keyAdapter);
                cellEditor.getControl().addTraverseListener((TraverseListener)keyAdapter);
                cellEditor.getControl().addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusGained(FocusEvent e) {
                        bars.clearGlobalActionHandlers();
                        bars.updateActionBars();
                    }

                    public void focusLost(FocusEvent e) {
                    }
                });
                this.cellEditors[i] = cellEditor;
            }
            ++i;
        }
        viewer.setColumnProperties(properties);
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                int index = Integer.parseInt(property);
                if (element instanceof TableElement) {
                    TableElement elem = (TableElement)element;
                    Object obj = elem.getItems()[index - 1];
                    if (obj != null) {
                        if (obj instanceof String) {
                            return (String)obj;
                        }
                        return CellEditorType.getDataTypeName(elem.getColumns()[index]);
                    }
                    return "";
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
            }
        });
        viewer.setCellEditors(this.cellEditors);
    }

    public void setTotalCount(int dispCount, long totalCount) {
        NumberFormat format = NumberFormat.getInstance();
        String displayCount = format.format(dispCount);
        String displayTotalCount = format.format(totalCount);
        StringBuffer sb = new StringBuffer();
        sb.append(displayCount);
        sb.append(Messages.getString("QueryViewEditor2.3"));
        if (!"".equals(displayTotalCount)) {
            if (!"-1".equals(displayTotalCount)) {
                sb.append(" / ");
                sb.append(Messages.getString("QueryViewEditor2.7"));
                sb.append(totalCount);
                sb.append(Messages.getString("QueryViewEditor2.8"));
            }
        } else {
            sb.append(Messages.getString("QueryViewEditor2.9"));
        }
        sb.append(Messages.getString("QueryViewEditor2.10"));
        sb.append(this.responseTime);
        sb.append("]");
        this.setPageText(this.getActivePage(), sb.toString());
    }

    public void setResponseTime(String responseTime) {
        this.responseTime = responseTime;
        if (this.responseTimeItem != null && responseTime != null && !"".equals(responseTime)) {
            StringBuffer sb = new StringBuffer();
            sb.append(Messages.getString("QueryViewEditor2.13"));
            sb.append(responseTime);
            this.responseTimeItem.setText(sb.toString());
        }
    }

    public void update(String query, TableElement[] elements, String responseTime, boolean isReload) {
        try {
            this.query = query;
            if (this.getPageText(0).equals("log")) {
                this.removePage(0);
            }
            if (this.viewer == null) {
                this.elements = elements;
                this.createMainPage();
            } else {
                TableElement element = elements[0];
                if (this.isSameColumn(element)) {
                    this.viewer.setInput((Object)elements);
                    TableColumn col = this.viewer.getTable().getColumn(0);
                    col.pack();
                    TableDefaultSortListener defaultSortListener = new TableDefaultSortListener(this, 0);
                    col.removeSelectionListener((SelectionListener)this.sortListener);
                    col.addSelectionListener((SelectionListener)defaultSortListener);
                    this.viewer.getTable().getColumn(0).notifyListeners(13, null);
                    col.removeSelectionListener((SelectionListener)defaultSortListener);
                    this.sortListener = new TableSortListener(this, 0);
                    col.addSelectionListener((SelectionListener)this.sortListener);
                } else {
                    this.elements = elements;
                    if (this.getPageCount() > 0) {
                        this.removePage(this.getPageCount() - 1);
                    }
                    this.createMainPage();
                }
            }
            if (!isReload) {
                QueryViewEditorInput ei = (QueryViewEditorInput)this.getEditorInput();
                DbPlugin.showView("zigen.plugin.db.ui.views.SQLExecuteView", ei.getSecondarlyId());
            }
            this.setResponseTime(responseTime);
            int dispCnt = elements.length - 1;
            this.setTotalCount(dispCnt, -1L);
            QueryViewEditorInput input = (QueryViewEditorInput)this.getEditorInput();
            RecordCountForQueryJob job2 = new RecordCountForQueryJob(Transaction.getInstance(this.config), query, input.getSecondarlyId(), dispCnt);
            job2.setUser(false);
            job2.setPriority(30);
            job2.schedule();
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                QueryViewEditor2.this.getContributor().fillContextMenu(manager);
                QueryViewEditor2.this.setExtensionPoint(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private QueryViewerContributor getContributor() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof QueryViewerContributor) {
            return (QueryViewerContributor)contributor;
        }
        return null;
    }

    private void setHeaderColumn(Table table) {
        if (this.elements != null) {
            TableColumn row = new TableColumn(table, 131072);
            this.sortListener = new TableSortListener(this, 0);
            row.addSelectionListener((SelectionListener)this.sortListener);
            row.pack();
            TableElement element = this.elements[0];
            zigen.plugin.db.core.TableColumn[] columns = element.getColumns();
            int i = 0;
            while (i < columns.length) {
                zigen.plugin.db.core.TableColumn tColumn = columns[i];
                TableColumn col = new TableColumn(table, 16384);
                col.setText(tColumn.getColumnName());
                col.addSelectionListener((SelectionListener)new TableSortListener(this, i + 1));
                col.pack();
                ++i;
            }
        }
    }

    private void columnsPack(Table table) {
        table.setVisible(false);
        TableColumn[] cols = table.getColumns();
        int i = 0;
        while (i < cols.length) {
            TableColumn c = cols[i];
            c.pack();
            if (c.getWidth() > this.max_column_size) {
                c.setWidth(this.max_column_size);
            }
            ++i;
        }
        table.setVisible(true);
    }

    public void dispose() {
        this.disposeExtensionPoint();
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        try {
            if (editorInput instanceof QueryViewEditorInput) {
                QueryViewEditorInput input = (QueryViewEditorInput)editorInput;
                this.config = input.getConfig();
                this.query = input.getQuery();
                this.setPartName("[" + this.config.getDbName() + Messages.getString("QueryViewEditor2.17"));
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public ITable getTableNode() {
        return null;
    }

    public TableElement getHeaderTableElement() {
        if (this.elements.length > 0) {
            return this.elements[0];
        }
        return null;
    }

    protected void initializeViewerFont(ISourceViewer viewer) {
        StyledText styledText = viewer.getTextWidget();
        styledText.setFont(DbPlugin.getDefaultFont());
    }

    void setGlobalActionForEditor(IActionBars bars) {
        bars.clearGlobalActionHandlers();
        this.copyAction.refresh();
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.selectAllRecordAction);
        bars.updateActionBars();
    }

    public void setFocus() {
        if (this.table != null && this.copyAction != null && this.selectAllRecordAction != null) {
            IActionBars bars = this.getEditorSite().getActionBars();
            bars.clearGlobalActionHandlers();
            this.setGlobalActionForEditor(bars);
            this.table.setFocus();
            this.setResponseTime(this.responseTime);
        }
    }

    private boolean isSameColumn(TableElement target) {
        zigen.plugin.db.core.TableColumn[] targetCols;
        int targetLen;
        if (this.elements == null) {
            return false;
        }
        TableElement old = this.elements[0];
        zigen.plugin.db.core.TableColumn[] oldCols = old.getColumns();
        int oldLen = oldCols.length;
        if (oldLen != (targetLen = (targetCols = target.getColumns()).length)) {
            return false;
        }
        int i = 0;
        while (i < oldCols.length) {
            zigen.plugin.db.core.TableColumn column1 = oldCols[i];
            zigen.plugin.db.core.TableColumn column2 = targetCols[i];
            if (!column1.getColumnName().equals(column2.getColumnName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IDBConfig getDBConfig() {
        return this.config;
    }

    public String getQuery() {
        return this.query;
    }

    public void changeColumnColor(Column column) {
    }

    public void changeColumnColor() {
        this.changeColorJob.setTable(this.table);
        this.changeColorJob.schedule();
    }

    public void editTableElement(Object element, int column) {
        throw new UnsupportedOperationException("The method is a unmounting.");
    }

    public String getCondition() {
        throw new UnsupportedOperationException("The method is a unmounting. ");
    }

    private void setExtensionPoint(IMenuManager manager) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(String.valueOf(DbPlugin.getDefault().getBundle().getSymbolicName()) + ".queryEditor");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            this.add(manager, elements);
            ++i;
        }
    }

    private void add(IMenuManager menu, IConfigurationElement[] elems) {
        try {
            int k = 0;
            while (k < elems.length) {
                block16: {
                    String _name;
                    IMenuManager subMenu;
                    IConfigurationElement element = elems[k];
                    String name = element.getName();
                    if ("contributor".equals(name)) {
                        try {
                            IContributionManager mgr;
                            Separator sep;
                            ITableViewEditorAction action = (ITableViewEditorAction)element.createExecutableExtension("class");
                            action.setText(element.getAttribute("label"));
                            action.setToolTipText(element.getAttribute("tooltipText"));
                            action.setActiveEditor(this);
                            action.selectionChanged(this.viewer.getSelection());
                            this.extensionList.add(action);
                            String menubarPath = element.getAttribute("menubarPath");
                            subMenu = menu.findMenuUsingPath(menubarPath);
                            if (subMenu != null) {
                                subMenu.add((IAction)action);
                                this.add(subMenu, element.getChildren());
                                break block16;
                            }
                            IContributionItem item = menu.findUsingPath(menubarPath);
                            if (item == null) break block16;
                            if (item instanceof Separator) {
                                sep = (Separator)item;
                                mgr = sep.getParent();
                                mgr.add((IAction)action);
                                this.add(subMenu, element.getChildren());
                                break block16;
                            }
                            if (item instanceof GroupMarker) {
                                sep = (GroupMarker)item;
                                mgr = sep.getParent();
                                mgr.add((IAction)action);
                                this.add(subMenu, element.getChildren());
                                break block16;
                            }
                            DbPlugin.log("unexpected Type " + item.getClass().getName());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    } else if ("menu".equals(name)) {
                        String _id = element.getAttribute("id");
                        String _label = element.getAttribute("label");
                        subMenu = menu.findMenuUsingPath(_id);
                        if (subMenu == null) {
                            subMenu = new MenuManager(_label, _id);
                            menu.add((IContributionItem)subMenu);
                            this.add(subMenu, element.getChildren());
                        }
                    } else if ("separator".equals(name)) {
                        _name = element.getAttribute("name");
                        menu.add((IContributionItem)new Separator(_name));
                    } else if ("groupMarker".equals(name)) {
                        _name = element.getAttribute("name");
                        menu.add((IContributionItem)new GroupMarker(_name));
                    }
                }
                ++k;
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    private void disposeExtensionPoint() {
        Iterator iter = this.extensionList.iterator();
        while (iter.hasNext()) {
            ITableViewEditorAction action = (ITableViewEditorAction)iter.next();
            action.setActiveEditor(null);
            Object var2_2 = null;
        }
    }

    public void setEnabled(boolean enabled) {
    }

    public int getRecordLimit() {
        return 0;
    }

    public int getRecordOffset() {
        return 0;
    }
}

