/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.csv;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.csv.AbstractCsvMappingFactory;
import zigen.plugin.db.csv.CSVConfig;
import zigen.plugin.db.csv.ICsvMappingFactory;

public class CSVWriter {
    private String DEMILITER = ",";
    private IDBConfig config = null;
    private CSVConfig csvConfig = null;
    private ICsvMappingFactory factory = null;

    public CSVWriter(IDBConfig config, CSVConfig csvConfig) {
        this.config = config;
        this.csvConfig = csvConfig;
        this.factory = AbstractCsvMappingFactory.getFactory(config, csvConfig.isNonDoubleQuate());
        if (csvConfig.getSeparator() != null && !"".equals(csvConfig)) {
            this.DEMILITER = csvConfig.getSeparator();
        }
    }

    public void execute() throws Exception {
        Connection con = Transaction.getInstance(this.config).getConnection();
        this.execute(con, this.csvConfig.getQuery());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(Connection con, String query) throws Exception {
        PrintStream pout;
        Statement stmt;
        block9: {
            ResultSet rs = null;
            stmt = null;
            pout = null;
            try {
                try {
                    pout = new PrintStream((OutputStream)new FileOutputStream(this.csvConfig.getCsvFile()), true, this.csvConfig.getCsvEncoding());
                    stmt = con.createStatement();
                    rs = stmt.executeQuery(query);
                    ResultSetMetaData meta = rs.getMetaData();
                    if (!this.csvConfig.isNonHeader()) {
                        this.writeColumnLabel(pout, meta);
                    }
                    this.writeColumnValue(pout, rs);
                }
                catch (Exception e) {
                    DbPlugin.log(e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (pout == null) throw throwable;
                pout.close();
                throw throwable;
            }
            {
                Object var7_10 = null;
                if (rs == null) break block9;
            }
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        if (pout == null) return;
        pout.close();
    }

    private void writeColumnLabel(PrintStream pout, ResultSetMetaData meta) throws SQLException {
        int size = meta.getColumnCount();
        int i = 0;
        while (i < size) {
            if (i == size - 1) {
                pout.println("\"" + meta.getColumnLabel(i + 1) + "\"");
            } else {
                pout.print("\"" + meta.getColumnLabel(i + 1) + "\"" + this.DEMILITER);
            }
            ++i;
        }
    }

    private int writeColumnValue(PrintStream pout, ResultSet rs) throws Exception {
        ResultSetMetaData meta = rs.getMetaData();
        int size = meta.getColumnCount();
        int recordNo = 1;
        while (rs.next()) {
            int i = 0;
            while (i < size) {
                String value = this.factory.getCsvValue(rs, i + 1);
                if (i == size - 1) {
                    pout.println(value);
                } else {
                    pout.print(String.valueOf(value) + this.DEMILITER);
                }
                ++i;
            }
            ++recordNo;
        }
        return recordNo;
    }
}

