<?php {
  /*
   * $Id: common-func.php,v 1.19 2003/04/19 01:48:58 tumf Exp $
   * Copyright(c) 2001-2003 Dino Co.,Ltd. All rights reserved.
   */


  /**
   *
   *@access public
   *@package default
   */


  function abs_url_internal($mode) {
    // $mode: 1 - rootdir / 2 - currdir / 3 - currfile

    if ($GLOBALS["HTTPS"] == "on") { $scheme = "https://"; }
    else { $scheme = "http://"; }
    $http_host = $GLOBALS["HTTP_HOST"];
    if (empty($http_host)) {
      $http_host = $GLOBALS["SERVER_NAME"];
      $server_port = $GLOBALS["SEVER_PORT"];
      if ($server_port && ($server_port != 80)) {
	$http_host .= ":$server_port";
      }
    }

    if ($mode == 1) {
      $script_name = "";
    } else if (ereg("^(/.*/)?([^\?/]*)$", $GLOBALS["PHP_SELF"], $regs)) {
      if ($mode == 2) {
	$script_name = $regs[1];
      } else if ($mode == 3) {
	$script_name = $regs[1] . $regs[2];
      } else {
	// ?????
	$script_name = "/";
      }
    } else {
      // ?????
      $script_name = "/";
    }
    $ret = sprintf("%s%s%s",
		   $scheme, $http_host, $script_name);
    return $ret;
  }

  // returns http://www.dino.co.jp
  function abs_url_of_root_dir() {
    return abs_url_internal(1);
  }
  // returns http://www.dino.co.jp/path/to/
  function abs_url_of_current_dir() {
    return abs_url_internal(2);
  }
  // returns http://www.dino.co.jp/path/to/file
  function abs_url_of_current_file() {
    return abs_url_internal(3);
  }

  /**
   * лURL?˼äơRFCŪURLǤ
   * ./Ȥ../ȤϤʤ
   * ŪˤƱǥ쥯ȥΥեե̾˽񤤤ƻȤ
   */
  function header_abs_location($url) {
    if (ereg("^https?:\/\/", $url)) {
      header("Location: " . $url);
    } elseif (ereg("^/", $url)) {
      header("Location: " . abs_url_internal(1) . $url);
    } else {
      //header("Location: " . abs_url_of_current_dir() . $url);
      header("Location: " . abs_url_internal(2) . $url);
    }
  }

  /**
   * Το$total Τ$numϲ%ˤʤ뤫ʸ֤
   *
   * ʲ2ޤǽФȤˤ롣
   * $total0ä硢0.00֤
   * λͤˤʤϤδؿ˰Ϥ˥å٤
   *
   *
   */
  function my_percent_str($num, $total) {
    if ($total == 0) {
      return "0.00";
    }
    return sprintf("%.2f", ($num * 100.0 / $total));
  }

  /**
   *  $keyname  get/post 饰Хѿˤ
   * 
   * pkey λ:
   * 1ʾĹʸ  ͷ(int/serial/datatime/timespan)
   * 
   * $_GET[$keyname]ӡ$_GET[$keyname]  stringǤȲꤷƤޤ
   * $_GET[$keyname] = 0 λGLOBAL˥åȤޤ
   * POSTGETͥ褵ޤ
   *
   * @author tumf
   * @return boolean $keynamepkeyȤХѿ˥åȤtrue
   * @access public
   * @param string $keyname globalѿȤʤGET/POSTѿ̾
   */
  function import_pkey_from_query($keyname){
    // POST
    if(strlen($_POST[$keyname])>0){
      $GLOBAL[$keyname]=$_POST[$keyname];
      return true;
    }

    //GET
    if(strlen($_GET[$keyname])>0){
      $GLOBAL[$keyname]=$_GET[$keyname];
      return true;
    }
    return false;
  }



  function globalize_get_post_vars($varname){
    if (empty($_GET[$varname])) {
      if (empty($_POST[$varname])) {
	return false;
      }else{
	$GLOBAL[$varname]=$_POST[$varname];
      }
    }else{
      $GLOBAL[$varname]=$_GET[$varname];
    }
    return true;
  }


  function strip_quotes_query_string() {
    if(ini_get(magic_quotes_gpc)) {
      foreach ($_REQUEST as $key => $val){
	$GLOBALS[$key] = stripslashes($val);
      }
    }
  }
  

} ?>
