<?php {
  /*
   *  page饹
   *  Υե 
   *   PukiWiki(http://pukiwiki.org/) ̤ήѤƤޤ
   *   PukiWiki Copyright (C) 2001,2002 PukiWiki Developers Team,sng.
   *            License is GNU/GPL.
   *   $Id: link.php,v 1.10 2003/04/03 08:56:28 ksk Exp $
   *   This file is modified by Dino Co.,Ltd.
   */

   /**
    * page饹
    *
    * @access public
    * @package Dino_Page
    */
  class link_util {
    var $page_list=array();
    var $strip_link_wall=true;
    var $WikiName = '[A-Z][a-z]+(?:[A-Z][a-z]+)+';
    //$BracketName = '\[\[(:?[^\s\]#&<>":]+:?)\]\]';
    var $BracketName = '\[\[(?!\/|\.\/|\.\.\/)(:?[^\s\]#&<>":]+:?)(?<!\/)\]\]';
    var $InterWikiName = "\[\[(\[*[^\s\]]+?\]*):(\[*[^>\]]+?\]*)\]\]";

    var $LinkPattern ;
    
    function make_LinkPattern(){
      $this->LinkPattern = "/( (?# <1>:all)
	(?# url )
	(?:\[\[([^\]]+):)?           (?#<2>:alias)
		(\[)?                      (?#<3>:open bracket)
			((?:(?:(?:https?|ftp|news):\/)|\.)(?:\/[!~*'();\/?:\@&=+\$,%#\w.-]+)) (?#<4>:url)
		(?(3)\s([^\]]+)\])         (?#<5>:alias, close bracket if <3>)
	(?(2)\]\])                   (?# close bracket if <2>)
	|
	(?# mailto)
	(?:\[\[([^\]]+):)?           (?#<6>alias)
		([\w.-]*@[\w-]+\.[\w.-]+(?:\?.*)?)  (?#<7>:mailto>)
	(?(6)\]\])                   (?# close bracket if <6>)
	|
	(?# BracketName or InterWikiName)
	(\[\[                        (?#<8>:all)
		(?:
			(\[\[)?                  (?#<9>:open bracket)
			([^\[\]]+)               (?#<10>:alias)
			(?:(?:&gt;)|>)           (?# '&gt;' or '>')
		)?
		(?:
			(\[\[)?                  (?#<11>:open bracket)
			(:?[^\s\[\]#&<>\":]*?:?) (?#<12>BracketName)
			((?(9)\]\]|(?(11)\]\])))?(?#<13>:close bracket if <9> or <11>)
			(\#(?:[a-zA-Z][\w-]*)?)? (?#<14>anchor)
			(?(13)|(?(9)\]\]|(?(11)\]\]))) (?#close bracket if <9> or <11> but !<13>)
			|
			(\[\[)?                  (?#<15>:open bracket)
			(\[*?[^\s\]]+?\]*?)      (?#<16>InterWiki)
			((?(9)\]\]|(?(15)\]\])))?(?#<17>:close bracket if <9> or <15>)
			(\:.*?)                  (?#<18>param)
			(?(17)|(?(9)\]\]|(?(15)\]\]))) (?#close bracket if <9> or <15> but !<17>)
		)?
	\]\])
	|
	(?# WikiNmae)
	({$this->WikiName})                  (?#<19>:all)
	)/x";
    }

    function link_util(){
      $this->make_LinkPattern();
    }

    // [[ ]] 
    function strip_bracket($str){
      if($this->strip_link_wall){
	  if(preg_match("/^\[\[(.*)\]\]$/",$str,$match)) {
	    $str = $match[1];
	  }
      }
      return $str;
    }
    // ڡ̾Υ󥳡
    function encode($key){
      $enkey = '';
      $arych = preg_split("//", $key, -1, PREG_SPLIT_NO_EMPTY);
	
      foreach($arych as $ch){
	$enkey .= sprintf("%02X", ord($ch));
      }
	
      return $enkey;
    }
  }

  class link_wrapper extends link_util{
    var $page;
    var $page_edit=false;

    function link_wrapper($page){
	  parent::link_util();
	  $this->page = $page; 
    }

    function &_convert($arr){
      if ($arr[4]  != '')
	return new link_url($arr[4],$arr[2].$arr[5]);
      if ($arr[7]  != '')
	return new link_mailto($arr[7],$arr[6]);
      if ($arr[16] != '')
	return new link_interwiki("[[$arr[16]$arr[18]]]",$arr[10]);
      if ($arr[12] != '' or $arr[14] != '')
	return $this->expand_bracket($arr,$this->page);
      if ($arr[19] != ''){
	$obj =  new link_wikiname($arr[19],$arr[19],'',$this->page,$this->page_list);
	$obj->page_edit=$this->page_edit;
	return $obj;
      }	  
      return new link($arr[0]); //ɤǤʤ
    }

    function &_replace_link($arr){
      $obj = $this->_convert($arr);

      return $obj->toString();
    }
    function &_replace($str){
      return preg_replace_callback($this->LinkPattern,array($this,'_replace_link'), $str);
    }
    function &make_link($str){
      if (!is_array($str))
	return $this->_replace($str);

      $tmp = array();

      foreach ($str as $line)
	$tmp[] = $this->_replace($line);

      return $tmp;
    }
    function &get_link($str){
      preg_match_all($this->LinkPattern,$str,$matches,PREG_SET_ORDER);

      $tmp = array();

      foreach ($matches as $arr)
	$tmp[] =& $this->_convert($arr);

      return $tmp;
    }
    // лȤŸ
    function get_fullname($name,$refer){
      global $defaultpage;
	
      if ($name == '[[./]]')
	return $refer;

      if (substr($name,0,4) == '[[./')
	return '[['.$this->strip_bracket($refer).substr($name,3);
	
      if (substr($name,0,5) == '[[../'){
	$arrn = preg_split("/\//",$this->strip_bracket($name),-1,PREG_SPLIT_NO_EMPTY);
	$arrp = preg_split("/\//",$this->strip_bracket($refer),-1,PREG_SPLIT_NO_EMPTY);
	while ($arrn[0] == '..') { array_shift($arrn); array_pop($arrp); }
	$name = (count($arrp)) ? '[['.join('/',array_merge($arrp,$arrn)).']]' :
	  ((count($arrn)) ? "[[$defaultpage/".join('/',$arrn).']]' : $defaultpage);
		
	// [[FrontPage/hoge]]οƤ[[FrontPage]]ǤϤʤFrontPage(Ȥ)
	$_name = $this->strip_bracket($name);
	if (preg_match("/^$this->WikiName$/",$_name))
	  $name = $_name;
      }
	
      return $name;
    }

    //BracketNameν
    function &expand_bracket($name,$refer){
      global $defaultpage;
	
      if (is_array($name))
	$arr = $name;
      else if (preg_match("/^$this->WikiName$/",$name)){
	$obj =  new link_wikiname($name,'','','',$this->page_list);
	$obj->page_edit=$this->page_edit;
	return $obj;
      }
      else if (!preg_match($this->LinkPattern,$name,$arr) or $arr[12] == '')
	return new link($name);
	
      $arr = array_slice($arr,8,7);
      $_name = array_shift($arr);
      
      $bracket = ($arr[0] or $arr[2]);
      $alias = $arr[1];
      $name = $arr[3];
      $anchor = $arr[5];
      
      if ($name != ''){
	if ($alias == '' and $anchor == '')
	  $name = "[[$name]]";
	else if (!$bracket and preg_match("/^$this->WikiName$/",$name)){
	  $obj =  new link_wikiname($name,$alias,$anchor,$refer,$this->page_list);
	  // var_dump($this->page_edit);exit;
	  $obj->page_edit=$this->page_edit;
	  return $obj;
	}else
	  $name = "[[$name]]";
      }
	
      if ($alias == ''){
	$alias = $this->strip_bracket($name).$anchor;
      }
      if ($name == ''){
	if($anchor == ''){
	  return new link($_name);
	}
	$obj=new link_wikiname($name,$alias,$anchor,$refer,$this->page_list);
	$obj->page_edit=$this->page_edit;
	return $obj;
      }
      $name = $this->get_fullname($name,$refer);
	
      if ($name == '' or preg_match("/^$this->WikiName$/",$name)){
	$obj=new link_wikiname($name,$alias,$anchor,$refer,$this->page_list);
	$obj->page_edit=$this->page_edit;
	return $obj;
      }
      else if (!preg_match("/^$this->BracketName$/",$name)) 
	return new link($_name);
	
      $obj=new link_wikiname($name,$alias,$anchor,$refer,$this->page_list);
      $obj->page_edit=$this->page_edit;
      return $obj;
    }
  
  }

  class link extends link_util{
    var $type,$name,$char,$alias;
    var $page_edit=false;

    function link($name,$type = '',$alias = ''){
      parent::link_util();
      $this->name = $name;
	  $this->type = $type;
	  $this->char = '0'.$name;
	  $this->alias = $alias;
    }
    function toString(){
      return $this->name;
    }
    function compare($a,$b){
      return strnatcasecmp($a->char,$b->char);
    }
  }

  class link_url extends link{
    var $is_image,$image;
    var $link_target="_blank";
      
    function link_url($name,$alias){
	  parent::link($name,'url',($alias == '') ? $name : $alias);
	  
	  if ($alias == '' and preg_match("/\.(gif|png|jpeg|jpg)$/i",$name)) {
	    $this->is_image = TRUE;
	    $this->image = "<img src=\"$name\" border=\"0\" alt=\"$alias\">";
	  } else if (preg_match("/\.(gif|png|jpeg|jpg)$/i",$alias)) {
	    $this->is_image = TRUE;
	    $this->image = "<img src=\"$alias\" border=\"0\" alt=\"$name\">";
	  } else {
	    $this->is_image = FALSE;
	    $this->image = '';
	  }
    }

    function toString(){
      $br=new Dino_Browser;

      if(preg_match("/^\.\//",$this->name)){
	$result 
	  = "<a href=\"{$this->name}\"\">"
	  .($this->is_image ? $this->image : $this->alias)
	  .'</a>';
      }else{
	$result 
	  = "<a href=\"{$this->name}\" target=\"{$this->link_target}\">"
	  .($this->is_image ? $this->image : $this->alias)
	  .'</a>';
      }

      // ӤüʤֳؤΥ󥯡פΥޡĤ
      if($br->is_mobileagent()){
	$result .=$br->emoji("\xf8\xd9","[]");
      }
      return $result;
    }
  }

  class link_mailto extends link{
    function link_mailto($name,$alias){
      parent::link($name,'mailto',($alias == '') ? $name : $alias);
    }
    function toString(){
      return "<a href=\"mailto:$this->name\">{$this->alias}</a>";
    }
  }

  class link_interwiki extends link{
      var $rawname;

      function link_interwiki($name,$alias){
	  parent::link($name,'InterWikiName',($alias == '') ? $this->strip_bracket($name) : $alias);
	  $this->rawname = rawurlencode($name);
      }

      function toString(){
	  global $script,$interwiki_target;

	  return "<a href=\"$script?$this->rawname\" target=\"$interwiki_target\">{$this->alias}</a>";
      }
  }

  class link_wikiname extends link {
    var $is_bracketname; //FALSE:'WikiName' TRUE:'BracketName';
    var $anchor;
    var $strip,$special,$rawname,$rawrefer,$passage;

    function is_exist($name){
      //print_r($this->page_list);
      foreach( $this->page_list as $aa=>$bb){
	// echo $this->strip_bracket($name);
	//printf("%s:%s<br/>",$bb["key"],$this->strip_bracket($name));
	if($bb["key"]==$this->strip_bracket($name)){
	  return true;
	}
      }
      return false;
    }

    function is_page($name){
      return $this->is_exist($name);
    }

    // ե̾(󥳡ɤƤɬͭ)
    function get_filename($pagename){
      return false;
      // return DATA_DIR.$pagename.".txt";
    }

    function link_wikiname($name,$alias='',$anchor='',$refer='',$page_list){
      global $script,$vars,$related;
      $this->page_list=$page_list;
      $this->is_bracketname = (substr($name,0,1) == '[');
      parent::link($name,$this->is_bracketname ? 'BracketName' : 'WikiName',($alias == '') ? $this->strip_bracket($name).$anchor : $alias);
      $this->anchor = $anchor;
      $this->strip = $this->strip_bracket($name);
      $this->char = ((ord($this->strip) < 128) ? '0' : '1').$this->strip;
      $this->special = htmlspecialchars($this->strip);
      $this->rawname = rawurlencode($name);
      $this->rawrefer = rawurlencode($refer);

      if ($vars['page'] != $name and $this->is_page($name)){
// 	$related['t'.filemtime($this->get_filename($this->encode($name)))] 
// 	  = "<a href=\"$script?{$this->rawname}\">{$this->special}</a>".$this->passage();
      }
    }

    function passage(){
      global $show_passage;
      $passage = get_pg_passage($this->name,FALSE);
      $this->passage = $show_passage ? $passage : '';
      return $passage;
    }

    function toString($refer = ''){
	global $script;

	if ($this->name == '' and $this->anchor != '')
	  return "<a href=\"{$this->anchor}\">{$this->alias}</a>";

	if ($this->is_page($this->name))
	  return "<a href=\"$script?key={$this->rawname}{$this->anchor}\" title=\"{$this->special}{$this->passage}\">{$this->alias}</a>";
	else {
	  $rawrefer = ($refer != '') ? rawurlencode($refer) : $this->rawrefer;
	  if($this->page_edit){
	    return "<span class=\"noexists\">$this->alias<a href=\"page_edit.php?key={$this->rawname}&amp;refer=$rawrefer\">?</a></span>";
	  }
	  return $this->alias;

	  // return "<span class=\"noexists\">$this->alias<a href=\"$script?cmd=edit&amp;page={$this->rawname}&amp;refer=$rawrefer\">?</a></span>";
	}
    }
  }
} ?>
